load('speed_experiment.mat')
temp = accuracy_all{1};
correlations = mean(temp{1},3);


do_significance_tests(correlations);
exportgraphics(gcf,'plots/speed_all_D1.eps','ContentType','vector')


function do_significance_tests(vals)

    x = repmat(1:size(vals,2),size(vals,1),1);
    
    for i=1:size(vals,2)
        bar(i, nanmean(vals(:,i)), 'EdgeColor', 'none', 'FaceAlpha', 0.7);
        hold on
        scatter(x(:,i),vals(:,i),30,'black','filled')
        hold on
    end
    for i = 1:size(vals,2) - 1
        plot([i,i+1], vals(:,[i,i+1])', 'Color', 'black', 'linestyle', '-','LineWidth',1)
        hold on
    end
    for i = 1:size(vals,2) - 1
        p = signrank(vals(:,i),vals(:,i+1));
        sigstar([i,i+1],p)
    end

    set(gca, 'color', 'none', 'xcolor', 'none');
end