function plot_metric_crossmice(avg_metric_ft, std_metric_ft, avg_metric, std_metric,avg_human, std_human, methods, method_indices, x, H, color_map, metric_name, ylim_range)
% This is a helper function. This function help plot the average metric in
% each iteration.
% INPUT
%   [avg_metric] : (K x H) a matrix of average metric values for each
%                   method k and horizon h. Horizon h = sorted 0.1% cells.
%   [std_metric] : (K x H) a matrix of the std of metric values. 
%   [avg_human]  : (float) the average human performance.
%   [std_human]  : (float) the std of human performance.
%   [methods]    : (K structs) the metrhods list
%   [method_indices] : [1 x L) the indices of method that want to be plotted. 
%   [x]          : the x-axis 1:1:H/10, represent the percentage of cells.
%   [H]          : (int) H/10 is the percentage of cells
%   [color_map]  : color map for each method k
%   [metric_name]: the name of the plotting metrics
%   [ylim_range] : (optional) (1 x 2)


figure;
for i = 1:length(method_indices)
    k = method_indices(i);
    method = methods{k};
    dspname = get_legend_name(method);

    mean_y_ft = avg_metric_ft(k,:);
    std_y_ft  = std_metric_ft(k,:);
    plot(x, mean_y_ft, 'DisplayName',dspname, 'Color',color_map(i,:), 'LineStyle','-', 'LineWidth',0.5)
    hold on
    % create shaded region
    shade_x = [x, fliplr(x)];
    shade_y = [mean_y_ft + std_y_ft, fliplr(mean_y_ft - std_y_ft)];
    fill(shade_x, shade_y,color_map(i,:),  'FaceAlpha', 0.2,'EdgeColor','none'); % Fill the region with cyan color and 30% transparency
    hold on

    mean_y = avg_metric(k,:);
    std_y  = std_metric(k,:);
    plot(x, mean_y, 'DisplayName',dspname, 'Color',color_map(i,:), 'LineStyle','--', 'LineWidth',0.5)
    hold on
    % create shaded region
    shade_x = [x, fliplr(x)];
    shade_y = [mean_y + std_y, fliplr(mean_y - std_y)];
    fill(shade_x, shade_y,color_map(i,:),  'FaceAlpha', 0.1,'EdgeColor','none'); % Fill the region with cyan color and 30% transparency
    hold on
end

line([1, H]./10, [avg_human, avg_human], 'Color', 'k', 'LineStyle', '--', 'DisplayName', 'human', 'LineWidth', 0.5);
hold on
% create shaded region
x = [1, H] ./ 10;  % Define the x coordinates
y1 = avg_human - std_human;  % Lower bound of the shaded area
y2 = avg_human + std_human;  % Upper bound of the shaded area
fill([x fliplr(x)], [y1*ones(size(x)) fliplr(y2*ones(size(x)))], 'k', 'FaceAlpha', 0.1, 'EdgeColor', 'none');

if nargin == 13
    ylim(ylim_range)
end

hold off
% legend()
title(metric_name)

figName = "crossmice_scft_al_"+metric_name+".pdf";
exportgraphics(gcf,figName,'ContentType','vector')

end