function [q_idxs, scores] = strategy_cal(dataset, n, mdl)
% Active learning query strategy 
% Output selected query indices [q_idxs] for the unlabeled training dataset
% i.e., [dataset.X_train[~labeled_idxs,:]]. 
% Update the [dataset] with [dataset.labeled_idxs]
		
% Query
% unlabeled_idxs = find(dataset.labels_ex == 0);
% if isempty(unlabeled_idxs) % Return NaN if all the cells are sorted
%     q_idxs = NaN;
%     return
% end
% [~, probs] = predict(mdl, dataset.features(unlabeled_idxs,:));
% log_probs = log(probs);
% uncertainties = -sum(probs.*log_probs, 2); % calculate entropy
% 
% [sortedValues, sortedIndices] = sort(uncertainties, 'descend');
% q_idxs = unlabeled_idxs(sortedIndices(1:n));
% scores = sortedValues(1:n);


[~, probs] = predict(mdl, dataset.features);
probs = probs(:,2);
confidences = abs(probs - 0.5);
confidences(dataset.labels_ex ~= 0) = inf;
%[scores, q_idxs] = min(confidences);
[sortedValues, sortedIndices] = sort(confidences, 'ascend');
q_idxs = sortedIndices(1:n);
scores = sortedValues(1:n);
end