clear
clc
pick = 4;

load('ebrahimi_reanalysis.mat')
switch pick
    case 1
    annotator = 'lion';
    choices = lion_choices;
    case 2
        annotator = 'guinea_pig';
        choices = guinea_pig_choices;
    case 3
        annotator = 'dragon';
        choices = dragon_choices;
    case 4
        annotator = 'cheetah';
        choices = cheetah_choices;
end


features = metrics';
infs = isinf(features);
features(infs) = 0;
features = zscore(features, 0, 1);
features(infs) = 0;

probs = (cheetah_choices +dragon_choices + guinea_pig_choices + lion_choices) / 4;
probs = probs*2+3;
[preds_train,preds_test] = get_classifier_preds(features,choices);

%%
un_vals = unique(probs);
met = mean(preds_test,1);
figure
for i=1:size(un_vals,2)
    ind = find(probs == un_vals(i));
    x = zeros(1,size(ind,2))+i;
    y = met(ind);
    swarmchart(x,y,1,'black','filled')
    hold on
    scatter(i,mean(y>0.5),100,[.5 0 .5],'filled','o')
    hold on
    scatter(i,mean(choices(ind)>0),300,'red','x')
    hold on
end
hold on
boxplot(met,probs, 'symbol', '')
hold on

set_common_gca_props


exportgraphics(gcf,['Fig_' annotator '.eps'],'ContentType','vector')


function set_common_gca_props
ax = gca;
ax.Color = 'none';
ax.LineWidth = 1.5;
ax.TickLength = [0.03, 0.03];
end