function [method, dataset] = parse_method(method, dataset)
% Return the method and dataset based on the user's defined parameters
% stored in method
% [INPUT]
%   [method]  : (struct)
%   [dataset] : (struct)
% [OUTPUT]
%   [method]  : (struct)
%   [dataset] : add the parameters in method (struct)
switch method.name
    case 'dcal'
        dataset.weight = method.weight;
    case 'mab-exp3'
        N = size(dataset.features, 1);
        dataset.wt    = ones(N,1);
        dataset.gamma = method.gamma; % 0.7;
        dataset.reward_func = method.reward_func; % @(tp, tn, fp, fn) ((0.3*(tp / (tp + fn)) + 0.7*(tn / (fp + tn))) / 2); % user can define the reward function in multi-arm bandit
    case 'mab-ucb'
        dataset.alpha = method.alpha;
end
end