# SeCo
Semantic Connectivity-Driven Pseudo-labeling for Cross-domain Segmentation.


## :speech_balloon: Requirements

```
Python 3.8.0
pytorch 1.10.1
torchvision 0.11.2
einops  0.3.2
```
Please see `requirements.txt` for all the other requirements.

You can use PSA and SCC to obtain high-purity connectivity-based pseudo-labels. 
These pseudo-labels can then be exploited and embedded into existing unsupervised domain adaptative semantic segmentation methods.

## :speech_balloon: Pixel Semantic Aggregation

First, you can obtain pixel-level pseudo-labels by pixel thresholding (e.g.[cbst](https://github.com/yzou2/cbst) ) from a UDA method (e.g. [ProDA](https://github.com/microsoft/ProDA) ) or a source-free UDA method (e.g. [DTST](https://github.com/DZhaoXd/DT-ST)), or a UDG method (e.g. [SHADE](https://github.com/HeliosZhao/SHADE) ).  
And organize them in the following format.   
```
"""
├─image
├─pixel-level pseudo-label
└─list
"""
list (XXX.txt) records the image names (XXX.png) and their corresponding pixel-level pseudo-labels.
```
Then, run the PSA as follows:
```
${exp_name}="HRDA_seco"
CUDA_VISIBLE_DEVICES="1"  nohup python seco_sam.py --id-list-path  ./splits/cityscapes/${exp_name}/all.txt --class-num ${class_name}  > logs/${exp_name} 2>&1 &
```
Afterward, you can find the aggregated pseudo-labels in `root_path/${exp_name}_vit_{B/H}`.


## :speech_balloon: Semantic Connectivity Correction
After PSA, the noise is also amplified, and then you can use SCC to denoise the connected regions. 
Refer to [SCC] part for specific instructions.





