#nus_to_nerf
import os
from nus_loader_swps import nus_loader
import numpy as np
import json
from pathlib import Path
import configargparse

def get_arg_parser():
    parser = configargparse.ArgumentParser()
    parser.add_argument("--samples",action="store_true")
    parser.add_argument(
        "--start",
        type=int, 
        default=480,
        help="choose start",
    )
    return parser

def main():
    parser = get_arg_parser()
    opt = parser.parse_args()
    root= '../../data/nuscenes/nuscenes-mini'
    
    if opt.samples:
        frames_root='../../data/nuscenes/nuscenes-mini/samples/LIDAR_TOP'
    else:
        frames_root='../../data/nuscenes/nuscenes-mini/sweeps/LIDAR_TOP'

    T_list,frames_list=nus_loader(root,frames_root)

    if opt.samples:
        T_list=T_list[opt.start:opt.start+36]
        frames_list=frames_list[opt.start:opt.start+36]
    else:
        T_list=T_list[opt.start:opt.start+180:5]
        frames_list=frames_list[opt.start:opt.start+180:5]
    for frame in frames_list:
        print(frame)

    #print(frames_list)
    #val_frames_list=[frames_list[9],frames_list[19],frames_list[29],frames_list[39]]
    #val_T_list=[T_list[9],T_list[19],T_list[29],T_list[39]]
    
    val_frames_list=[frames_list[9],frames_list[19],frames_list[29]]
    val_T_list=[T_list[9],T_list[19],T_list[29]]
    #print(val_frames_list)

    range_view_dir = "../../data/nuscenes/train_swps"
    range_view_paths_train=[os.path.join(range_view_dir,"{}.npy".format(frame.rsplit('.bin', 1)[0])) for frame in frames_list]
    #range_view_paths_val=[os.path.join(range_view_dir,"{}.npy".format(frame.rsplit('.bin', 1)[0])) for frame in val_frames_list]

    # Get image dimensions, assume all images have the same dimensions.
    lidar_range_image = np.load(range_view_paths_train[0])
    lidar_h, lidar_w, _ = lidar_range_image.shape

    #
    lidar_paths_split_train=[path for path in range_view_paths_train]
    lidar2world_split_train=[T_list[i] for i in range(len(T_list))]
    lidar2world_split_train=np.array(lidar2world_split_train)

    #lidar_paths_split_val=[path for path in range_view_paths_val]
    #lidar2world_split_val=[T for T in val_T_list]
    #lidar2world_split_val=np.array(lidar2world_split_val)

    #for split in ['train','val','test']:
    #if split=='train':
    lidar_paths_split=lidar_paths_split_train
    lidar2world_split=lidar2world_split_train
    #else:
        #lidar_paths_split=lidar_paths_split_val
        #lidar2world_split=lidar2world_split_val
    json_dict = {
            "w_lidar": lidar_w,
            "h_lidar": lidar_h,
            "aabb_scale": 2,
            "frames": [
                {
                    "lidar_file_path": str(
                        lidar_path[3:]
                    ),
                    "lidar2world": lidar2world.tolist(),"lidar_file_without_ground_path":str(lidar_path.split(".pcd")[0][3:]+".pcd.withoutground.npy"),
                }
                for (
                    lidar_path,
                    lidar2world,
                ) in zip(
                    lidar_paths_split,
                    lidar2world_split,
                )
            ],
        }
    json_path = os.path.join('../../data/nuscenes',f"{opt.start}_transforms_train_swps.json")

    with open(json_path, "w") as f:
        json.dump(json_dict, f, indent=2)
        print("Saved")
    


if __name__ == "__main__":
    main()
