#!/bin/bash

CURR_DIR=$(cd $(dirname "$0") && pwd)
RUN_DIR="$CURR_DIR/train.py"
SEED=0
EPOCHS=200

python $RUN_DIR \
    exp_name=EXAMPLE_RUN \
    run_name=cifar10_erm_${EPOCHS}epochs_seed${SEED} \
    \
    model=resnet18 \
    dataset=cifar10 \
    \
    epochs=$EPOCHS \
    eval_model_every_k_epochs=1 \
    \
    sam_rho=0.0 \
    \
    get_fs_stats=true \
    \
    seed=$SEED \
    gpu=5 \
