"""
Pre-initialization for FloorPlan4 task.
FloorPlan4's drawers are closed so the agent can later open
"""

class SceneInitializer:
    def __init__(self) -> None:
        self.drawers = ['Drawer|-00.82|+00.75|-01.69', 
                        'Drawer|-00.45|+00.75|-00.01', 
                        'Drawer|-00.07|+00.75|-00.01']

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        for drawer in self.drawers: 
            event = controller.step(
            action = 'CloseObject',
            objectId = drawer,
            forceAction = True
            )

        return event