"""
Pre-initialization for FloorPlan4 task.
FloorPlan4: bread and tomato don't need to be moved
egg needs to be taken out of fridge and placed on
diningtable
- rotate agent 180
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated
        
        event = controller.step(action="RotateRight", degrees=180)

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Bread|-00.18|+01.12|+01.89',
            position= {'x': -0.85400000035762787, 'y': 1.1191563606262207, 'z': 1.8919998407363892}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Tomato|-00.75|+01.08|+02.40',
            position= {'x': -0.8468804121017456, 'y': 1.0815151929855347, 'z': 2.3995256423950195}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Egg|-03.37|+01.30|+02.85',
            position= {'x': -0.5667587339878082, 'y': 1.1131519079208374, 'z': 0.68327492475509644},
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Lettuce|-03.31|+00.97|+03.04',
            position= {'x': -0.1800000035762787, 'y': 1.1191563606262207, 'z': 1.8919998407363892},
        )

        return event