"""
To check completion of subtasks in 2_turn_on_all_stove_knobs task.
Also checks coverage of the task and success of the task.
Subtasks:
    • NavigateTo(StoveKnob) or NavigateTo(StoveBurner)
    • ToggleObjectOn(StoveKnob_1)
    • ToggleObjectOn(StoveKnob_2)
    • ToggleObjectOn(StoveKnob_3)
    • ToggleObjectOn(StoveKnob_4)
Coverage:
    • StoveKnob_1
    • StoveKnob_2
    • StoveKnob_3
    • StoveKnob_4
    • StoveKnob_5
    • StoveKnob_6
FloorPlan1: 4 stove knobs
FloorPlan2: 6 stove knobs
FloorPlan3: 4 stove knobs
FloorPlan4: 4 stove knobs
FloorPlan5: 4 stove knobs
FloorPlan6: 4 stove knobs
"""

from AI2Thor.baselines.utils.checker import BaseChecker


class Checker(BaseChecker):
    def __init__(self) -> None:
        subtasks = [
            "NavigateTo(StoveKnob)",
            "ToggleObjectOn(StoveKnob_1)",
            "ToggleObjectOn(StoveKnob_2)",
            "ToggleObjectOn(StoveKnob_3)",
            "ToggleObjectOn(StoveKnob_4)",
        ]
        conditional_subtasks = []
        independent_subtasks = [
            "NavigateTo(StoveKnob)",
            "ToggleObjectOn(StoveKnob_1)",
            "ToggleObjectOn(StoveKnob_2)",
            "ToggleObjectOn(StoveKnob_3)",
            "ToggleObjectOn(StoveKnob_4)",
        ]
        coverage = ["StoveKnob_1", "StoveKnob_2", "StoveKnob_3", "StoveKnob_4"]
        interact_objects = ["StoveKnob_1", "StoveKnob_2", "StoveKnob_3", "StoveKnob_4"]
        interact_receptacles = []

        super().__init__(
            subtasks,
            conditional_subtasks,
            independent_subtasks,
            coverage,
            interact_objects,
            interact_receptacles,
        )

    def check_subtask(self, action, success, inventory_object):
        """Check if subtask is completed"""
        act, object = self.split_action(action)
        if act == "NavigateTo":
            if (
                "Stove" in object
                and success
                and "NavigateTo(StoveKnob)" not in self.subtasks_completed
            ):
                self.subtasks_completed.append("NavigateTo(StoveKnob)")
                self.subtasks_completed_numerated.append("NavigateTo(StoveKnob)")
        elif act == "ToggleObjectOn":
            if (
                object
                in [
                    "StoveKnob_1",
                    "StoveKnob_2",
                    "StoveKnob_3",
                    "StoveKnob_4",
                    "StoveKnob_5",
                    "StoveKnob_6",
                ]
                and success
                and f"ToggleObjectOn({object})" not in self.subtasks_completed
            ):
                self.subtasks_completed.append(f"ToggleObjectOn({object})")
                self.subtasks_completed_numerated.append(f"ToggleObjectOn({object})")
