from pathlib import Path
import os, sys

# set parent directory to address relative imports
directory = Path(os.getcwd()).absolute()
sys.path.append(
    str(directory)
)  # note: no ".parent" addition is needed for python (.py) files

from AI2Thor.baselines.utils.logging import Logger
from AI2Thor.baselines.utils.auto_config import AutoConfig

import argparse
parser = argparse.ArgumentParser()
parser.add_argument('--baseline', type=str)
parser.add_argument('--task', type=int, default=None)
parser.add_argument('--name', type=str, default=None)
parser.add_argument('--agents', type=int, default=2)
args = parser.parse_args()

# autoconfig
auto=AutoConfig()
num_tasks=auto.get_amt_tasks()

print(f"Creating bash file for '{args.baseline}' baseline\n")

# main_s = lambda t,fp : f"sudo python AI2Thor/baselines/decomposed_modules/decomposed_modules.py --task={t} --floorplan={fp}\n"
# pprint  = lambda t,fp  : f"sudo python print.py --task={t} --floorplan={fp}\n"
# bash_directory = 'decomposed_modules.sh'

if args.name is None:
    args.name=args.baseline
# @change - main_s assumed that the folder of the baseline is the same as the name of the baseline.py file!!
main_s = lambda t,fp : f"sudo python AI2Thor/baselines/{args.baseline}/{args.baseline}.py --task={t} --floorplan={fp} --name='{args.name}' --agents={args.agents}\n"
pprint  = lambda t,fp  : f"sudo python meta/print.py --task={t} --floorplan={fp}\n"
bash_directory = f'meta/{args.baseline}.sh'
print(f"file output in '{bash_directory}'")

s=""
tasks=[args.task] if args.task is not None else range(num_tasks)
for t in tasks:
    print(f'Auto {t}...')
    auto.set_task(t)
    num_fps=auto.get_amt_floorplans(t)
    s+=f"\n # task {t} - all floorplans \n"
    for fp in range(num_fps):
        s+=main_s(t,fp)
        s+=pprint(t,fp)

with open(bash_directory, 'w') as f:
    f.write(s)

print('Written.')
