"""
Pre-initialization for FloorPlan2 task.
FloorPlan2 does not need any modifications for the task
of clearing the table.
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass
        
    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """
    
            # initialization function - autogenerated
    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Bread|+00.26|+00.99|-00.08',
        position={'x': 0.25613734126091003, 'y': 0.9874744415283203, 'z': -0.07600241154432297}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Egg|+00.13|+00.95|-00.17',
        position={'x': 0.13453038036823273, 'y': 0.954975426197052, 'z': -0.16909891366958618}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Tomato|+00.17|+00.97|-00.28',
        position={'x': 0.16839563846588135, 'y': 0.974504292011261, 'z': -0.28153562545776367}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Mug|-00.24|+00.92|-00.26',
        position={'x': -0.23500609397888184, 'y': 0.9150000214576721, 'z': -0.25599977374076843}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Bowl|+00.28|+00.92|+01.09',
        position={'x': 0.2765314280986786, 'y': 0.916129469871521, 'z': 1.091195821762085}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Potato|+00.33|+00.94|+01.31',
        position={'x': 0.3274422585964203, 'y': 0.940034806728363, 'z': 1.3115100860595703}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='CellPhone|-00.31|+00.92|+01.29',
        position={'x': 0.2714024782180786, 'y': 0.9157505035400391, 'z': 1.8878094911575318}
        )
                    
        return event
            