"""
Pre-initialization for FloorPlan5 task.
FloorPlan5:
- move the plate out the way and
- place plate, mug, and bowl in their respective positions
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        event = controller.step(action="RotateLeft", degrees=95)
        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Bowl|-00.51|+01.12|+00.54', 
            position= {'x': 1.451570205688477, 'y': 0.9002388715744019, 'z': -1.5544999361038208}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Pan|+01.74|+00.90|-01.97',
            position= {'x': 0.53099484145641327, 'y': 1.120038390159607, 'z': 0.5670008063316345}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Plate|-01.12|+00.90|-01.65',
            position= {'x': 1.18477, 'y': 0.9488715744019, 'z': -1.84999361038208}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Mug|+00.13|+01.12|+00.57',
            position = {'x': 1.451570205688477, 'y': 0.9002388715744019, 'z': -1.2544999361038208}
        )

        return event