import carla
import random

from carla_env.simulator.simulator import Simulator
from carla_env.simulator.traffic_manager import TrafficManager
from carla_env.simulator.world import World


class Client(carla.Client):
    """The client of the simulator. This class is a wrapper of the carla.Client class.

    Args:
        host (str): The host of the simulator.

        port (int): The port of the simulator.

    """

    def __init__(self, simulator: Simulator, host: str, port: int) -> None:
        super().__init__(host, port)
        world = self.get_world()
        self.__world = World(world, simulator)
        self.set_timeout(10.0)

    def get_trafficmanager(self, client_connection: int = 8000) -> TrafficManager:
        return TrafficManager(super().get_trafficmanager(client_connection))

    @property
    def world(self) -> World:
        """The world of the simulator."""
        return self.__world

    @property
    def traffic_manager(self) -> TrafficManager:
        """The traffic manager of the simulator."""
        return self.get_trafficmanager()

    def texture_setter(self):
        texture = carla.TextureColor(64, 64)
        for x in range(64):
            for y in range(64):
                r = 0
                g = 0
                b = 0
                a = 255
                texture.set(x, y, carla.Color(r, g, b, a))

        for obj in self.__world.get_environment_objects():
            if 'Apart' in obj.name:
                print(obj.name)
            self.__world.apply_color_texture_to_object(obj.name, texture)