# Just Add $100 more
* Our project webpage is https://just-add-100-more.github.io/
  * The code is available on the project webpage.
  * All pseudo objects that are free from video copyright issues used in data generation can be found on the project page.
    * Only 3 pairs of raw images and masked images for each individual miniature are included, due to the limitation of supplementary space. 
      * Please refer to the webpage for the remaining data.
    * The `pgt_lidar_bank` contains the point clouds of the pseudo objects. 
      * Due to capacity limitations, only a portion of the samples used for training is included.
      * The coordinates assume that the ego vehicle is positioned at (0,0) with its heading aligned with the x-axis, following a right-hand coordinate system.
      * The naming convention for point clouds in the pgt_lidar_bank is as follows.
        * if a motorcycle4 is located at x: -10, y: 10 with a heading angle of -90 degrees, the file name would be `n10p10_motorcycle4_n90.bin`.
        * if a motorcycle5 is located at x: 10, y: 10 with a heading angle of 150 degrees, the file name would be `p10p10_motorcycle5_150.bin`.
    * The mapping table between the names of objects in the `image` and `rgb_dense_points` folder and the corresponding object names in the `pgt_lidar_bank` is as follows.
    ```python 
    # key: object names in pgt_lidar_bank, value: object names in the image and rgb_dense_points folder
    truck = {
        'truck0': 'blackyellow_truck',
        'truck1': 'bluewhite_truck',
        'truck2': 'deepblue_truck',
        'truck3': 'dhl_truck',
        'truck4': 'mickey_truck',
        'truck5': 'white_truck',
        'truck6': 'yellow_truck',
    }
    bicycle = {
        'bicycle0': '1_bicycle',
        'bicycle1': '2_bicycle',
        'bicycle2': '3_bicycle'
    }
    bus = {
        'bus0': 'blue_bus',
        'bus1': 'lightblue_bus',
        'bus2': 'red_bus'
    }
    construction_vehicle = {
        'construction_vehicle0': '1_loader',
        'construction_vehicle1': '2_loader', 
        'construction_vehicle2': '3_loader', 
        'construction_vehicle3': 'cons_construction', 
        'construction_vehicle4': 'fire_construction', 
        'construction_vehicle5': 'folk_construction', 
        'construction_vehicle6': 'orange_construction', 
        'construction_vehicle7': 'trans_construction', 
        'construction_vehicle8': 'yellow2_loader', 
        'construction_vehicle9': 'yellow_excavator', 
    }
    motorcycle = {
        'motorcycle0': '1_motor',
        'motorcycle1': '2_motor',
        'motorcycle2': '3_motor',
        'motorcycle3': 'nohuman1_motor',
        'motorcycle4': 'nohuman2_motor',
        'motorcycle5': 'nohuman3_motor',
    }
    trailer = {
        'trailer0': 'bluewhite_trailer',
        'trailer1': 'deepblue_trailer',
        'trailer2': 'mickey_trailer',
        'trailer3': 'yellow_trailer',
    }
    ```

    
