from .q_learner import QLearner
from .noise_q_learner import QLearner as NoiseQLearner
from .ctr_q_learner import QLearner as CTRQLearner
from .coma_learner import COMALearner
from .actor_critic_learner import ActorCriticLearner
from .qtran_learner import QLearner as Qtranlearner
from .ppo_learner import PPOLearner as PPOLearner
from .ctr_ppo_learner import PPOLearner as CTRPPOLearner

REGISTRY = {}

REGISTRY["q_learner"] = QLearner
REGISTRY["noise_q_learner"] = NoiseQLearner
REGISTRY["ctr_q_learner"] = CTRQLearner
REGISTRY["coma_learner"] = COMALearner
REGISTRY["actor_critic_learner"] = ActorCriticLearner
REGISTRY["qtran_learner"] = Qtranlearner
REGISTRY["ppo_learner"] = PPOLearner
REGISTRY["ctr_ppo_learner"] = CTRPPOLearner
