import random
def read_files(cnf_file, core_file, save_file, origin_core, add_var=False, drat=None):
    with open(cnf_file) as cnf:
        content = cnf.readlines()
        while content[0].split()[0] == 'c':
            content = content[1:]
        num_vars = int(content[0].split(' ')[2])
        while content[0].split()[0] == 'p':
            content = content[1:]
        while len(content[-1].split()) <= 1:
            content = content[:-1]
    
    with open(core_file, encoding='windows-1252') as core:
        core_content = core.readlines()
        while core_content[0].split()[0] == 'c' or core_content[0].split()[0] == 'p':
            core_content = core_content[1:]
        while len(core_content[-1].split()) <= 1:
            core_content = core_content[:-1]
    
    if origin_core == None:
        return content, num_vars, core_content, None, None
    
    with open(origin_core) as origin:
        origin_content = origin.readlines()
        while origin_content[0].split()[0] == 'c' or origin_content[0].split()[0] == 'p':
            origin_content = origin_content[1:]
        while len(origin_content[-1].split()) <= 1:
            origin_content = origin_content[:-1]

    if drat == None:
        return content, num_vars, core_content, origin_content, None
    
    with open(drat) as drat:
        drat_content = drat.readlines()
        drat_content = drat_content[:-1]
    
    return content, num_vars, core_content, origin_content, drat_content



def attach_new_lit(cnf_file, core_file, save_file, origin_core,cnf_graph,add_var=False):
    content, num_vars, core_content, origin_content, _ = read_files(cnf_file, core_file, save_file, origin_core, add_var=add_var)
    hg = cnf_graph
    random.shuffle(core_content)
    for core_clause in core_content:
        origin_flag = False
        for origin_clause in origin_content:
            if set(core_clause.split(' ')) == set(origin_clause.split(' ')):
                origin_content.remove(origin_clause)
                origin_flag = True
                break
        if origin_flag:
            # print('====================================================================================')
            continue
        
        origin_flag = False
        for idx, clause in enumerate(content):
            if set(core_clause.split(' ')) == set(clause.split(' ')):
                if add_var:
                    num_vars += 1
                clause = f"{num_vars} " + clause
                content[idx] = clause
                origin_flag = True
                break
        if origin_flag:
            break
    
    with open(save_file, 'w') as out_file:
        # print("writing to", args.save)
        out_file.write("c generated by G2SAT lcg\n")
        out_file.write("p cnf {} {}\n".format(num_vars, len(content)))
        for clause in content:
            out_file.write(clause)

    return