#!/bin/bash
export CUDA_VISIBLE_DEVICES=2

set -e
set -x

python train.py \
    --dataset_name 'herbarium_19' \
    --model_id 'dino' \
    --batch_size 256 \
    --grad_from_block 11 \
    --epochs 200 \
    --num_workers 8 \
    --use_ssb_splits \
    --sup_weight 0.35 \
    --weight_decay 5e-5 \
    --transform 'imagenet' \
    --lr 0.1 \
    --eval_funcs 'v2' 'v2b' \
    --warmup_teacher_temp 0.07 \
    --teacher_temp 0.04 \
    --warmup_teacher_temp_epochs 40 \
    --memax_weight 2.0 \
    --exp_name herb19_simgcd \
    --asym-aug \
    --energy-align \
    -qkvl 5 6 \
    --align_strength 0.01 \
    --use-cutmixup
