#!/bin/bash
export CUDA_VISIBLE_DEVICES=0
set -e
set -x


python train.py \
    --dataset_name 'cub' \
    --model_id 'dino' \
    --batch_size 384 \
    --grad_from_block 10 \
    --epochs 200 \
    --num_workers 4 \
    --use_ssb_splits \
    --sup_weight 0.35 \
    --weight_decay 5e-5 \
    --transform 'imagenet' \
    --lr 0.2 \
    --eval_funcs 'v2' \
    --warmup_teacher_temp 0.07 \
    --teacher_temp 0.04 \
    --warmup_teacher_temp_epochs 30 \
    --memax_weight 2.0 \
    --exp_name cub_simgcd \
    --asym-aug \
    --energy-align \
    -qkvl 5 6 \
    --align_strength 0.01 \
    --use-cutmixup
    
    # --warmup_model_dir './dev_outputs/simgcd/dino/log/cub_simgcd_wte-20/checkpoints/model.pt'
    # --classifier_type 'cosine' \