function [x] = gradient_mapping(lambda,t,barx,gamma,f,g,grad_f,grad_g)

w = grad_f-grad_g;
b = f-g-t-dot(grad_f-grad_g,barx);
xstarf = barx - 1/gamma * grad_f;
xstarg = barx - 1/gamma * grad_g;
proj_xsf = proj_l2ball(xstarf,lambda);
proj_xsg = proj_l2ball(xstarg,lambda);
if f + dot(grad_f,proj_xsf - barx)-t>g + dot(grad_g,proj_xsf-barx)
    x = proj_xsf;
else 
    if g + dot(grad_g,proj_xsg-barx) > f + dot(grad_f,proj_xsg - barx)-t
        x = proj_xsg;
    else
        D = b/norm(w,2);
        C = - b/dot(w,w)*w;
        r = sqrt(lambda * lambda - D*D);
        x = xstarf - (dot(w,xstarf)+b)/dot(w,w)*w;
        if norm(x-C,2)>r
            x = C + (x-C)/norm(x-C,2)*r;
        end
    end
end
end
