
scaling_factor=$1
scaling_type=$2
model_type=$3
task_name=$4
step=$5


if [[ "$@" == *"flash_attn"* ]]; then
  flash_attn=1
else
  flash_attn=0
fi
echo "flash_attn: ${flash_attn}"


prefix=/scratch2/nlp/wutong/${task_name}/${model_type}_results

if [ "$scaling_factor" == "none" ]
then
    echo Llama-2-7b-chat-hf
    python -u src/eval_longbench.py \
        --model_name_or_path /scratch2/nlp/plm/Llama-2-7b-chat-hf \
        --model_max_position_embeddings 4096 \
        --use_flash_attn ${flash_attn} \
        --out_path_root eval_output/LongBench/${model_type}-${task_name}

else
    echo $scaling_type and $scaling_factor
    python -u src/eval_longbench.py \
        --model_name_or_path ${prefix}/4k-$((scaling_factor*4))k-${scaling_type}/checkpoint-${step} \
        --rope_scaling_type ${scaling_type} \
        --rope_scaling_factor ${scaling_factor} \
        --model_max_position_embeddings 4096 \
        --use_flash_attn ${flash_attn} \
        --out_path_root eval_output/LongBench/${model_type}-${task_name}-${step}-vicuna

fi

