from omegaconf import DictConfig, OmegaConf
import hydra
import pickle
import sys
import numpy as np
import sklearn.linear_model as skl
import argparse
from sklearn.decomposition import PCA
from pathlib import Path
import os 
import logging
from scipy.cluster.vq import vq, whiten, kmeans

logging.basicConfig(level = logging.INFO)

log = logging.getLogger(__name__)

@hydra.main(config_path="conf")
def main(cfg: DictConfig) -> None:
    log.info(f"Run testing for all electrodes in all test_subjects")
    log.info(OmegaConf.to_yaml(cfg, resolve=True))

    sub = cfg.exp.subject
    vq_n = cfg.exp.vq_n


    root = "/storage/user1/brain-diffuser/"
    train_path = os.path.join(root,f'data/processed_data/subj{sub:02d}/nsd_train_fmriavg_nsdgeneral_sub{sub}.npy')
    train_fmri = np.load(train_path)
    test_path = os.path.join(root,f'data/processed_data/subj{sub:02d}/nsd_test_fmriavg_nsdgeneral_sub{sub}.npy')
    test_fmri = np.load(test_path)


    whitened_train = whiten(train_fmri)
    whitened_test = whiten(test_fmri)

    code_book, distortion = kmeans(whitened_train, vq_n)
    coded_train, _ = vq(whitened_train, code_book)
    coded_test, _ = vq(whitened_test, code_book)


    train_fmri_compressed = code_book[coded_train]
    test_fmri_compressed = code_book[coded_test]
    out_path = os.path.join(root, f'data/vq_reduced/subj{sub:02d}/vq_{vq_n}')
    Path(out_path).mkdir(parents=True, exist_ok=True)
    out_path_train = os.path.join(out_path, f'train_fmri.npy')
    out_path_test = os.path.join(out_path, f'test_fmri.npy')

    np.save(out_path_train, train_fmri_compressed)
    np.save(out_path_test, test_fmri_compressed)


if __name__=="__main__":
    main()


