import logging
from omegaconf import DictConfig, OmegaConf
import hydra
import train_single
import itertools

logging.basicConfig(level = logging.INFO)

log = logging.getLogger(__name__)

@hydra.main(config_path="conf")
def main(cfg: DictConfig) -> None:
    log.info(f"Run hp sweep")
    log.info(OmegaConf.to_yaml(cfg, resolve=True))
    OmegaConf.set_struct(cfg, True)
    
    #cfg.exp.bottlenecks = [3000]
    #lrs = [1e-2, 1e-3, 1e-4, 1e-5]
    lrs = [1e-3]
    optims = ["Adam"]
    weight_decays = [1e-1]
    #weight_decays = [1e-1]#, 1e-2, 1e-3, 1e-4, 1e-5]
    products = itertools.product(lrs, optims, weight_decays)
    for elem in products:
        lr, optim, weight_decay = elem
        cfg.exp.reg.lr = lr
        cfg.exp.reg.optim = optim
        cfg.exp.reg.weight_decay = weight_decay
        train_single.main(cfg)

if __name__=="__main__":
    main()
