import os
import numpy as np
from pathlib import Path

path = f"/storage/user1/brain-diffuser/data/extracted_features/subj01/nsd_vdvae_features_31l.npz"

nsd_features = np.load(path)
arr = nsd_features['test_latents']

save_path_dir = f"/storage/user1/BrainBitsWIP/data/predicted_features/subj01/random_latents"
Path(save_path_dir).mkdir(exist_ok=True, parents=True)
rand_arr = np.random.random(arr.shape)
np.save(os.path.join(save_path_dir, f"vdvae_preds.npy"), rand_arr)

path = "/storage/user1/brain-diffuser/data/extracted_features/subj01/nsd_clipvision_test.npy"
arr = np.load(path)
rand_arr = np.random.random(arr.shape)
np.save(os.path.join(save_path_dir, f"clip_vision_preds.npy"), rand_arr)

path = "/storage/user1/brain-diffuser/data/extracted_features/subj01/nsd_cliptext_test.npy"
arr = np.load(path)
rand_arr = np.random.random(arr.shape)
np.save(os.path.join(save_path_dir, f"clip_text_preds.npy"), rand_arr)
