import json
from pathlib import Path
import numpy as np
from omegaconf import DictConfig, OmegaConf
import cv2 as cv
import hydra
import logging
import os
from PIL import Image

logging.basicConfig(level = logging.INFO)
log = logging.getLogger(__name__)

def color_eval(gt_features, pred_features):
    return {"color_mse":((gt_features - pred_features)**2).mean()}

@hydra.main(config_path="conf")
def main(cfg: DictConfig) -> None:
    log.info(f"Evaluate based on extracted features")
    log.info(OmegaConf.to_yaml(cfg, resolve=True))
    out_dir = os.getcwd()
    log.info(f'Working directory {os.getcwd()}')
    if "out_dir" in cfg.exp:
        out_dir = cfg.exp.out_dir
    log.info(f'Output directory {out_dir}')

    gt_features = cfg.exp.gt_features_path
    pred_features = cfg.exp.pred_features_path

    with open(os.path.join(gt_features, "features.npy"), "rb") as f:
        gt = np.load(f)

    with open(os.path.join(pred_features, cfg.exp.feat_name, "features.npy"), "rb") as f:
        pred = np.load(f)

    if cfg.exp.feat_name=="color":
        color_eval(gt, pred)

    if cfg.exp.feat_name=="color":
        results = color_eval(gt, pred)

    out_dir = os.path.join(out_dir, cfg.exp.feat_name)
    Path(out_dir).mkdir(exist_ok=True, parents=True)
    out_path = os.path.join(out_dir, "results.json")

    with open(out_path, "w") as f:
        json.dump(results, f)

if __name__=="__main__":
    main()

