import pickle
import sys
import numpy as np
import sklearn.linear_model as skl
import argparse
import os
from pathlib import Path

parser = argparse.ArgumentParser(description='Argument Parser')
parser.add_argument("-sub", "--sub",help="Subject Number",default=1)
parser.add_argument("-fmri_path", "--fmri_path",help="fmri data",default=None)
parser.add_argument("-out_path", "--out_path",help="fmri data",default=None)
args = parser.parse_args()
fmri_path = args.fmri_path
out_path = args.out_path
sub=int(args.sub)
assert sub in [1,2,5,7]

root = "/storage/user1/brain-diffuser/"
nsd_features = np.load(os.path.join(root, f'data/extracted_features/subj{sub:02d}/nsd_vdvae_features_31l.npz'))
train_latents = nsd_features['train_latents']
test_latents = nsd_features['test_latents']

train_path = os.path.join(fmri_path, 'train_fmri.npy')
train_fmri = np.load(train_path)
test_path = os.path.join(fmri_path, 'test_fmri.npy')
test_fmri = np.load(test_path)

## Preprocessing fMRI

train_fmri = train_fmri/300
test_fmri = test_fmri/300


norm_mean_train = np.mean(train_fmri, axis=0)
norm_scale_train = np.std(train_fmri, axis=0, ddof=1)
train_fmri = (train_fmri - norm_mean_train) / norm_scale_train
test_fmri = (test_fmri - norm_mean_train) / norm_scale_train

print(np.mean(train_fmri),np.std(train_fmri))
print(np.mean(test_fmri),np.std(test_fmri))

print(np.max(train_fmri),np.min(train_fmri))
print(np.max(test_fmri),np.min(test_fmri))

num_voxels, num_train, num_test = train_fmri.shape[1], len(train_fmri), len(test_fmri)

## latents Features Regression
print('Training latents Feature Regression')

reg = skl.Ridge(alpha=50000, max_iter=10000, fit_intercept=True)#TODO try this with a different alpha
reg.fit(train_fmri, train_latents)
pred_test_latent = reg.predict(test_fmri)
std_norm_test_latent = (pred_test_latent - np.mean(pred_test_latent,axis=0)) / np.std(pred_test_latent,axis=0)
pred_latents = std_norm_test_latent * np.std(train_latents,axis=0) + np.mean(train_latents,axis=0)
print(reg.score(test_fmri,test_latents))

Path(out_path).mkdir(exist_ok=True, parents=True)
np.save(os.path.join(out_path, 'vdvae_test_out.npy'),pred_latents)

datadict = {
    'weight' : reg.coef_,
    'bias' : reg.intercept_,
}

with open(os.path.join(out_path,"vdvae_regression_weights.pkl"),"wb") as f:
    pickle.dump(datadict,f)

