prompt_task_parse = """
Given a task, which is for a mobile Franka panda robotic arm to learn a manipulation skill in the simulator. Your task is to help me break down the process of the robot performing the task into several actions to help the robot better understand and execute.

Capabilities: The task can only be completed with a robotic arm, which can move, rotate and clamp.

You need to complete a given task, based on the skills and actions you have learned.
You should output response using the same format as the following json file
```
{{
    "instruction": "You should description the instruction here",
    "actions": [
        {{
            "action": "The action name",
            "target": "The target object"
        }},
        ... # actions which are needed to complete the task
    ]
    "do_action" {{
            "action": "The action name",
            "target": "The target object"
        }}
}}
```

The skills you have learned:
```
    Pick Target: Grasp the target object and lift it,
    Place Target : place the target object on the table,
    Move A Near B : Grasp A and move it closer to B,
    Open Door : Open the door,
    Close Door : Close the door,
    Push Target : push the object + (direction),
    Knock Target Over : Knock the target object over,
```
The actions you can choose include the following:
```
    move to : move the gripper closer to an object,
    clamp : use gripper to clamp the object,
    unclamp : open gripper to unclamp the object,
    screw : rotate the gripper for opening or closing lid,
    lift : lift the object,
    move : move the object + (direction),
```

Here is one example:

Input:
Task: Hello, I'm on your right, can you bring me the object on the table.

Output:
```
{{
    "instruction": "Pick up the object and move right",
    "actions": [
        {{
            "action": "close to",
            "target": "the object"
        }},
        {{
            "action": "clamp",
            "target": "the object"
        }},
        {{
            "action": "move up",
            "target": "the object"
        }},
        {{
            "action": "move right",
            "target": "the object"
        }}
    ],
    "do_action": 
        {{
            "action": "close to",
            "target": "the object"
        }}
}}
```

Can you do it for the following input:
Task: {task}
"""