import os
import re
import json
import random
from prompt.prompts import *
from collections import Counter
from macm.Executor import Execute_steps,Find_Answer
from macm.judge import Judge_statement,Judge_answer,Judge_condition
from macm.thinker import Analysis_conditions,Fix_conditions,Think_thoughts,Think_Steps

def check_condition(question,condition, n):
    """
    Use several Judges to check the statement
    Input:
    conditions, unchecked_conditions, the number of the inspectors (List, Str, int)
    Output:
    True/False (bool)
    """
    for _ in range(n):
        if Judge_condition(question,condition).strip() == "False":
            return False
    return True

def check_statement(conditions,statement, n):
    """
    Use several Judges to check the statement
    Input:
    conditions, unchecked_conditions, the number of the inspectors (List, Str, int)
    Output:
    True/False (bool)
    """
    for _ in range(n):
        answer = Judge_statement(conditions,statement)
        if  "False" in answer or "false" in answer:
            print("check_statement return False")
            return False
    print("check_statement return True")
    return True


def check_answer(conditions,statement):
    """
    Use several Judges to check the answer
    Input:
    unchecked_conditions, the number of the inspectors (Str, int)
    Output:
    True/False (bool)
    """
    if_got_answer = Judge_answer(conditions,statement)
    print("if_got_answer",if_got_answer,type(if_got_answer))
    if "False" in if_got_answer or "false" in if_got_answer:
        return False
    return True


def check_if_got_answer(conditions,statement,n):
    for _ in range(n):
        if check_answer(conditions,statement) == False:
            print("check_if_got_answer return False")
            return False
    print("check_if_got_answer return True")
    return True    

def main(question,times,n,voters):
    """
    Input question and get the final answer from muti-Agent got
    Input:
    quesion, the number of times new conditions are identified, the number of the inspectors  (Str, int, int)
    Output:
    final answer (Str)
    """
    possible_answers = []
    try:
        for voter in range(voters):
            conditions,objectives = Analysis_conditions(question)
            Initial_condition_numbers = len(conditions)
            print("Initial_condition_numbers:\n",Initial_condition_numbers)
            print("conditions:\n", conditions)
            print("objectives:\n", objectives)
            
            # Think thoughts
            while len(conditions) - Initial_condition_numbers <= times:
                print("\nBegin thinking new thoughts...")
                unchecked_conditions = Think_thoughts(conditions,objectives)
                print("\nunchecked_conditions:\n",unchecked_conditions)
                checked_conditions = []
                for unchecked_condition in unchecked_conditions:
                    print("\nBegin checking conditions...")
                    if check_statement(conditions,unchecked_condition,n):
                        start = unchecked_condition.find("we can get: ")
                        if start != -1:
                            unchecked_condition = unchecked_condition[start + len("we can get: "):]
                            unchecked_condition = unchecked_condition.split("Reason:")[0]
                        checked_conditions.append(unchecked_condition)
                print("checked_conditions:\n",checked_conditions)
                conditions = conditions + checked_conditions
                if_got_answer = check_if_got_answer(conditions,objectives,1)
                if if_got_answer:
                    break
            print("Final conditions:\n",conditions)
            print("\nBegin thinking steps...")
            steps = Think_Steps(conditions,objectives)
            print("step:\n",steps)
            final_answer = Execute_steps(conditions,objectives,steps)
            # final_answer = Find_Answer(conditions,objectives)
            print("One possible answer:\n",final_answer)
            Answer = re.search(r'\\boxed\{(.*)(?=\})', final_answer)  
            if Answer:
                Answer_boxed = Answer.group(1)
            else:
                Answer_boxed = "No match found"
            possible_answers.append(Answer_boxed)
        print("possible_answers",possible_answers)
        counter = Counter(possible_answers)
        most_possible_answer, count = counter.most_common(1)[0]
        print(f"The most possible answer is {most_possible_answer}")
        return most_possible_answer
    except Exception as e:
        print(f"Error processing file: {e}")
                           
                                        
if __name__ == "__main__":
    n = 1
    times = 5
    voters = 5
    question_list = []
    question = "" # Input the question that you want to ask
    main(question, times, n, voters)
