These codes are developed based on [OSRL](https://github.com/liuzuxin/OSRL). We evaluate WSAC and consider Behavior Cloning (BC), and one of the state-of-the-art algorithms, COptiDICE as baseline.

## Installation

You can install:
```bash
cd WSAC
pip install -e .
```

## How to use WSAC

The example usage are in the `examples` folder, where you can find the training and evaluation scripts for all the algorithms. 
All the parameters and their default configs for each algorithm are available in the `examples/configs` folder. 
OSRL uses the `WandbLogger` in [FSRL](https://github.com/liuzuxin/FSRL) and [Pyrallis](https://github.com/eladrich/pyrallis) configuration system. The offline dataset and offline environments are provided in [DSRL](https://github.com/liuzuxin/DSRL), so make sure you install both of them first.

### Training
For example, to train the `WSAC` method, simply run by overriding the default parameters:

```shell
python examples/train/train_WSAC.py --task OfflineCarCircle-v0 --param1 args1 ...
```
By default, the config file and the logs during training will be written to `logs\` folder and the training plots can be viewed online using Wandb.

The tasks can be:
```shell
OfflineCarCircle-v0
OfflineBallCircle-v0
OfflinePointButton2Gymnasium-v0
OfflinePointPush2Gymnasium-v0
```



