import init

init.enable_GPU = False

from Core import *
from Plotting import plotMinGenErrsN, plotMinGenStepsN, computeMinGenErrorRate
from datetime import datetime
import pickle

if __name__ == '__main__':
    name = "out/full_d1"

    D = 1
    ns = range(2000, 4001, 200)
    T_factor = 2
    ticks = 10000
    b0_factor = 2.
    repeats = 4 * 64
    N0 = 2_0000
    timestamp = f"{datetime.now():%m%d_%H%M}"
    filename = name + "_" + timestamp
    text = ""
    for gamma in [1.1, 2., 3.]:
        for p in [0.6, 1., 3.]:
            f_decay = (p + 1) / 2
            for q in [1., 1.5, 2.]:
                expr_res = repeatedExpr_parallel(ns, D=D, T_factor=T_factor, ticks=ticks,
                                                 f_decay=f_decay, f_gap=q, f_factor=1.0,
                                                 b0_factor=b0_factor,
                                                 lambda_decay=gamma,
                                                 repeats=repeats, N0=N0)
                k = computeMinGenErrorRate(expr_res)
                text += f"{k:.3f},"
        text += "\n"
    with open(filename + ".txt", "w") as f:
        f.write(text)
