import init

init.enable_GPU = False

from Core import *
from Plotting import plotMinGenErrsN, plotMinGenStepsN
from datetime import datetime
import pickle
# check the number of processors available
import multiprocessing

if __name__ == '__main__':

    ns = range(2000, 10001, 500)

    # Gradient descent
    # name = "out/example_GD"
    # expr_res = repeatedExpr_parallel(ns, D=-1, T_factor=200, ticks=1000,
    #                                  f_decay=1., f_gap=2, f_factor=1.0,
    #                                  b0_factor=1.,
    #                                  lambda_decay=1.5,
    #                                  repeats=64, N0=1_0000)

    # OpGD
    name = "out/example_OpGD"
    expr_res = repeatedExpr_parallel(ns, D=0, T_factor=2, ticks=1000,
                                     f_decay=1., f_gap=2, f_factor=1.0,
                                     b0_factor=1.,
                                     lambda_decay=1.5,
                                     repeats=64, N0=1_0000)

    timestamp = f"{datetime.now():%m%d_%H%M}"
    filename = name + "_" + timestamp
    with open(filename + ".pkl", "wb") as f:
        pickle.dump(expr_res, f)

    plotMinGenErrsN(expr_res, filename + ".pdf")
    plotMinGenStepsN(expr_res, filename + "_steps.pdf")
