import subprocess
import sys

from setuptools import setup, find_packages
from setuptools.command.install import install


class InstallPlaywrightCommand(install):
    """Customized setuptools install command that runs 'playwright install'."""

    def run(self):
        # Call the original install command to handle regular installation process
        install.run(self)

        # Attempt to run 'playwright install' using subprocess
        try:
            subprocess.check_call([sys.executable, "-m", "playwright", "install"])
            print("Successfully ran 'playwright install'.")
        except subprocess.CalledProcessError as e:
            print("Failed to run 'playwright install'. Please run 'playwright install' manually.")
            print(e)


setup(
    name="desktop_env",
    version="0.1.5",
    author="Tianbao Xie, Danyang Zhang,  Jixuan Chen, Xiaochuan Li, Siheng Zhao, Ruisheng Cao, Toh Jing Hua, etc.",
    author_email="tianbaoxiexxx@gmail.com",
    description="The package provides a desktop environment for setting and evaluating desktop automation tasks.",
    long_description=open('README.md', encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/xlang-ai/desktop_env",
    packages=find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.9',
    install_requires=[
        "numpy~=1.24.3",
        "Pillow~=10.1.0",
        "fabric",
        "gymnasium~=0.28.1",
        "requests~=2.31.0",
        "transformers~=4.35.2",
        "torch~=2.1.1",
        "accelerate",
        "opencv-python~=4.8.1.78",
        "matplotlib~=3.7.4",
        "pynput~=1.7.6",
        "pyautogui~=0.9.54",
        "psutil~=5.9.6",
        "tqdm~=4.65.0",
        "pandas~=2.0.3",
        "flask~=3.0.0",
        "requests-toolbelt~=1.0.0",
        "lxml",
        "cssselect",
        "xmltodict",
        "openpyxl",
        "python-docx",
        "python-pptx",
        "pypdf",
        "PyGetWindow",
        "rapidfuzz",
        "pyacoustid",
        "opencv-python",
        "ImageHash",
        "scikit-image",
        "librosa",
        "pymupdf",
        "chardet",
        "playwright",
        "formulas",
        "pydrive",
        "fastdtw",
        "odfpy",
        "func-timeout",
        "beautifulsoup4",
        "PyYaml",
        "mutagen",
        "easyocr",
        "borb",
        "pypdf2",
        "pdfplumber",
        "wrapt_timeout_decorator"
    ],
    cmdclass={
        'install': InstallPlaywrightCommand,  # Use the custom install command
    },
)