# @yaml
# signature: run_tests <path>
# docstring: runs all the tests defined in the given python file. The file should be a valid test file. Only failing tests are shown.
run_tests() {
    if [ $# -lt 1 ] || [ $# -gt 1 ] ; then
        echo "Usage: run_tests <path to test file>"
        return
    fi

    test_path="$1"

    if [ ! -f "$test_path" ]; then
        echo "The given file does not exist: $test_path"
        return
    fi

    absolute_path=$(realpath "$test_path")

    python3 "/root/tools/run_test.py" "$absolute_path"
}