import  numpy as np
from src.evaluation.aux.load_results import *
import matplotlib.pyplot as plt
import os
import argparse
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import config as config

time = "_Date-2022-05-25_Time-17-58"

'''this file plots figures in Appendix: I.1.3 Comparing CAMS with each individual expert'''

parser = argparse.ArgumentParser(
    description='task6 for plotting figures in Appendix: I.1.3 Comparing CAMS with each individual expert')
parser.add_argument('-t', default="time", type=str,
                    help='please input time of your .txt file generated by .sh bash file. For example, _Date-2022-05-18_Time-16-45')

args = parser.parse_args()
time = args.t

if time == "time":
    print("please input time of your .txt file generated by .sh bash file. For example, _Date-2022-05-18_Time-16-45")
    exit()

my_pal= config.COLOR

n_RS=config.n_RS
n_Oracle=config.n_CAMS_best_policy
n_QBC = config.n_qbc
n_IWAL = config.n_iwal
n_MP = config.n_mp
n_CQBC = config.n_contextual_qbc
n_CIWAL = config.n_contextual_iwal
n_CAMS = config.n_CAMS_identity
n_test = config.n_CAMS_test


def find_nearest(array, value):
    array = np.asarray(array)
    idx = (np.abs(array - value)).argmin()
    return array[idx]


def rename_method_list(methods,policy_name):
    arr=[]
    for item in methods:
        arr.append(policy_name)
    return arr


def organize_plot(dataset_name, folder_name, budget, policy_name="policy_name"):

    # Preprocess and loading data from experiment results
    path = os.getcwd() + "/resources/results/" + folder_name + "/"
    data = np.load(path + "data.npz")
    num_reals = data["num_reals"]
    print(dataset_name,":", num_reals)
    methods = data["methods"]
    budget_raw = data["budgets"]
    experiment_result = np.load(path + "experiment_results_budget" + str(budget) + ".npz")

    eval = np.load(path + "eval_results.npz")
    box_budget = eval["box_budget"]
    box_budget_actual = eval["box_budget_actual"]
    max_method=eval['max_method']
    max_budget_actual=eval['max_budget_actual']
    max_method = rename_method_list(max_method,policy_name)

    budget_arr=[]
    for item in budget_raw:
        budget_arr.append(item)

    max_bar_query=[]
    for item in max_budget_actual:
        min_bar=0
        for j in budget_raw:
            if  item >= j:
                min_bar=j
        max_bar_query.append(min_bar)

    eval_query_arr = []
    eval_query_arr_final = []
    for method_ in eval_query_arr:
        counter = 0
        array_temp = []
        for item in method_:
            counter = counter + item
            array_temp.append(counter)
        eval_query_arr_final.append(array_temp)

    box_cumulative_loss = eval["box_cumulative_loss"]
    box_method = eval["box_method"]
    box_ = np.repeat(policy_name,len(box_method))
    box_df_shading = {"budget": box_budget_actual,"budget_fixed": box_budget, "c_regret": box_cumulative_loss, "method": box_}
    box_df_shading = pd.DataFrame(box_df_shading)

    reshape_budget=[]
    reshape_budget_fixed=[]

    budget_raw=np.asarray(budget_raw)

    for index, row in box_df_shading.iterrows():
        reshape_budget.append(row['budget'])
        budget_w_max=np.concatenate((budget_raw,[max_budget_actual[max_method.index(row['method'])]]))
        round_value=find_nearest(budget_w_max ,row['budget'])

        if round_value == max_bar_query[max_method.index(row['method'])]:
            reshape_budget_fixed.append(max_budget_actual[max_method.index(row['method'])])
        else:
            reshape_budget_fixed.append(round_value)

    box_df_shading = {"budget": reshape_budget,"budget_fixed": reshape_budget_fixed, "c_regret": box_cumulative_loss, "method": box_}
    box_df_shading = pd.DataFrame(box_df_shading)

    for item in methods:
        for budget_ in budget_raw:
            print(item)
            x = np.where((box_df_shading["method"]==item) & (box_df_shading["budget_fixed"]== budget_))
            y = box_df_shading.loc[x]["budget"].mean()

            box_df_shading.iloc[[x], [box_df_shading.columns.get_loc("budget_fixed")]]=y

    shade_df_2=box_df_shading.filter(["budget_fixed","method","c_regret"],axis=1).drop_duplicates().reset_index(drop=True)
    print(shade_df_2)
    return shade_df_2


######################################################
#HIV
dataset_name="HIV"
budget=200

policy_0 ="HIV_contextual_streamsize4000_numreals100"+time+"_which_methods00000010000_policy[0]"
policy_1 ="HIV_contextual_streamsize4000_numreals100"+time+"_which_methods00000010000_policy[1]"
policy_5 ="HIV_contextual_streamsize4000_numreals100"+time+"_which_methods00000010000_policy[5]"
policy_6 ="HIV_contextual_streamsize4000_numreals100"+time+"_which_methods00000010000_policy[6]"
policy_2 ="HIV_contextual_streamsize4000_numreals100"+time+"_which_methods00000010000_policy[2]"
# policy_3 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[3]"
# policy_4 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[4]"
# policy_7 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[7]"
# policy_8 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[8]"

# policy_13 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[13]"
# policy_14 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[14]"
# policy_15 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[15]"
# policy_16 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[16]"
# policy_17 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[17]"
# policy_18 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[18]"
# policy_19 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[19]"
# policy_20 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[20]"
# policy_21 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[21]"
# policy_22 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[22]"
# policy_23 ="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[23]"


CAMS="HIV_contextual_streamsize4000_numreals100"+time+"_which_methods00000001000_policy[0]"
# CAMS="HIV_contextual_streamsize4000_numreals200"+time+"_which_methods00000010000_policy[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23]"

shade_df=[]
shade_df_0   = organize_plot( dataset_name, policy_0, budget,"policy_0")
shade_df_1   = organize_plot( dataset_name, policy_1, budget,"policy_1")
shade_df_5   = organize_plot( dataset_name, policy_5, budget,"policy_5")
shade_df_6   = organize_plot( dataset_name, policy_6, budget,"policy_6")
shade_df_2   = organize_plot( dataset_name, policy_2, budget,"policy_2")
# shade_df_3   = organize_plot( dataset_name, policy_3, budget,"policy_3")
# shade_df_4   = organize_plot( dataset_name, policy_4, budget,"policy_4")
# shade_df_7   = organize_plot( dataset_name, policy_7, budget,"policy_7")
# shade_df_8   = organize_plot( dataset_name, policy_8, budget,"policy_8")

# shade_df_13   = organize_plot( dataset_name, policy_13, budget,"policy_13")
# shade_df_14   = organize_plot( dataset_name, policy_14, budget,"policy_14")
# shade_df_15   = organize_plot( dataset_name, policy_15, budget,"policy_15")
# shade_df_16   = organize_plot( dataset_name, policy_16, budget,"policy_16")
# shade_df_17   = organize_plot( dataset_name, policy_17, budget,"policy_17")
# shade_df_18   = organize_plot( dataset_name, policy_18, budget,"policy_18")

# shade_df_19   = organize_plot( dataset_name, policy_19, budget,"policy_19")
# shade_df_20   = organize_plot( dataset_name, policy_20, budget,"policy_20")
# shade_df_21   = organize_plot( dataset_name, policy_21, budget,"policy_21")
# shade_df_22   = organize_plot( dataset_name, policy_22, budget,"policy_22")
# shade_df_23   = organize_plot( dataset_name, policy_23, budget,"policy_23")

shade_df_cams  =  organize_plot(dataset_name, CAMS, budget,      "CAMS")

shade_df=shade_df_cams

#shade_df=shade_df.append(shade_df_cams_max)
shade_df=shade_df.append(shade_df_0)
shade_df=shade_df.append(shade_df_1)
shade_df=shade_df.append(shade_df_5)
shade_df=shade_df.append(shade_df_6)
shade_df=shade_df.append(shade_df_2)
# shade_df=shade_df.append(shade_df_3)
# shade_df=shade_df.append(shade_df_4)
# shade_df=shade_df.append(shade_df_7)
# shade_df=shade_df.append(shade_df_8)

# shade_df=shade_df.append(shade_df_13)
# shade_df=shade_df.append(shade_df_14)
# shade_df=shade_df.append(shade_df_15)
# shade_df=shade_df.append(shade_df_16)
# shade_df=shade_df.append(shade_df_17)
# shade_df=shade_df.append(shade_df_18)
# shade_df=shade_df.append(shade_df_19)
# shade_df=shade_df.append(shade_df_20)
# shade_df=shade_df.append(shade_df_21)
# shade_df=shade_df.append(shade_df_22)
# shade_df=shade_df.append(shade_df_23)

plt.figure(figsize=(10, 10), dpi=300)

#sns.lineplot(x="budget_fixed", y="c_regret", hue="method",data=shade_df_cams,ci=63, color="grey", linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_0"],ci=63, color="purple",label = "best policy",linewidth=4)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_1"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_2"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_3"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_4"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_5"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_6"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_7"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_8"],ci=63, color="grey", linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_13"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_14"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_15"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_16"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_17"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_18"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_19"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_20"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_21"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_22"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_23"],ci=63, color="grey", linewidth=1)

#sns.lineplot(x="budget_fixed", y="c_regret", label = "CAMS_MAX", data=shade_df[shade_df["method"]=="CAMS_MAX"],color="k",ci=63, linewidth=2)
sns.lineplot(x="budget_fixed", y="c_regret", label = n_CAMS, data=shade_df[shade_df["method"]==n_CAMS],color=my_pal[n_CAMS],ci=63, linewidth=4)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.xlabel("Query cost", fontsize=30)
# plt.ylabel("Cumulative loss", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21,title=None)
plt.legend("")

plt.savefig("./task6/"+dataset_name + "_task6_policy_only.png", bbox_inches='tight', pad_inches=0.01)
plt.savefig("./task6/"+dataset_name + "_task6_policy_only.pdf", bbox_inches='tight', pad_inches=0.01)

print("completed!")


#########################################################
# DRIFT
dataset_name="DRIFT"
Budget=100

# policy_0="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[0]"
policy_1="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[1]"
policy_2="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[2]"
# policy_3="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[3]"
# policy_4="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[4]"
policy_5="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[5]"
# policy_6="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[6]"
policy_7="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[7]"
# policy_18="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[18]"
# policy_19="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[19]"
# policy_20="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[20]"
CAMS="drift_contextual_streamsize3000_numreals100"+time+"_which_methods00000010000_policy[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]"

shade_df=[]
# shade_df_0   = organize_plot( dataset_name, policy_0, budget,"policy_0")
shade_df_1   = organize_plot( dataset_name, policy_1, budget,"policy_1")
shade_df_2   = organize_plot( dataset_name, policy_2, budget,"policy_2")
# shade_df_3   = organize_plot( dataset_name, policy_3, budget,"policy_3")
# shade_df_4   = organize_plot( dataset_name, policy_4, budget,"policy_4")
shade_df_5   = organize_plot( dataset_name, policy_5, budget,"policy_5")
# shade_df_6   = organize_plot( dataset_name, policy_6, budget,"policy_6")
shade_df_7   = organize_plot( dataset_name, policy_7, budget,"policy_7")
# shade_df_18   = organize_plot( dataset_name, policy_18, budget,"policy_18")
# shade_df_19   = organize_plot( dataset_name, policy_19, budget,"policy_19")
# shade_df_20   = organize_plot( dataset_name, policy_20, budget,"policy_20")
shade_df_cams  =  organize_plot(dataset_name, CAMS, budget,      "CAMS")

shade_df=shade_df_cams
#shade_df=shade_df.append(shade_df_cams_max)
#shade_df=shade_df.append(shade_df_0)
shade_df=shade_df.append(shade_df_1)
shade_df=shade_df.append(shade_df_2)
#shade_df=shade_df.append(shade_df_3)
#shade_df=shade_df.append(shade_df_4)
shade_df=shade_df.append(shade_df_5)
#shade_df=shade_df.append(shade_df_6)
shade_df=shade_df.append(shade_df_7)
#shade_df=shade_df.append(shade_df_18)
#shade_df=shade_df.append(shade_df_19)
#shade_df=shade_df.append(shade_df_20)

plt.figure(figsize=(10, 10), dpi=300)
#sns.lineplot(x="budget_fixed", y="c_regret", hue="method",data=shade_df_cams,ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_0"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_1"],ci=63,label = "best policy",color="purple", linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_2"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_3"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_4"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_5"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_6"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_7"],ci=63, color="grey", linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_18"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_19"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_20"],ci=63, color="grey", linewidth=1)

#sns.lineplot(x="budget_fixed", y="c_regret", label = "CAMS_MAX", data=shade_df[shade_df["method"]=="CAMS_MAX"],color="k",ci=63, linewidth=2)
sns.lineplot(x="budget_fixed", y="c_regret", label = n_CAMS, data=shade_df[shade_df["method"]==n_CAMS],color=my_pal[n_CAMS],ci=63, linewidth=4)

plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.xlabel("Query cost", fontsize=30)
# plt.ylabel("Cumulative loss", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21,title=None)
plt.legend("")

plt.savefig("./task6/"+dataset_name + "_task6_policy_only.png", bbox_inches='tight', pad_inches=0.01)
plt.savefig("./task6/"+dataset_name + "_task6_policy_only.pdf", bbox_inches='tight', pad_inches=0.01)


####################################################################################################
# VERTEBRAL

dataset_name="VERTEBRAL"
budget=50
#policies
policy_0="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[0]"
policy_1="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[1]"
policy_2="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[2]"
policy_3="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[3]"
policy_4="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[4]"
policy_5="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[5]"
#policy_6="VERTEBRAL_contextual_streamsize80_numreals200_Date"+time+"_which_methods00000010000_policy[6]"

#malicious
policy_12="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[12]"
policy_13="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[13]"
policy_14="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[14]"
policy_15="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[15]"
policy_16="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[16]"
policy_17="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[17]"
policy_18="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[18]"
policy_19="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[19]"
policy_20="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[20]"
policy_21="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[21]"
policy_22="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000010000_policy[22]"

CAMS="VERTEBRAL_contextual_streamsize80_numreals200"+time+"_which_methods00000001000_policy[6]"

shade_df=[]
shade_df_0   = organize_plot( dataset_name, policy_0,budget,"policy_0")
shade_df_1   = organize_plot( dataset_name, policy_1,budget,"policy_1")
shade_df_2   = organize_plot( dataset_name, policy_2,budget,"policy_2")
shade_df_3   = organize_plot( dataset_name, policy_3,budget,"policy_3")
shade_df_4   = organize_plot( dataset_name, policy_4,budget,"policy_4")
shade_df_5   = organize_plot( dataset_name, policy_5,budget,"policy_5")
# shade_df_6   = organize_plot( dataset_name, policy_6,budget,"policy_6")
# shade_df_7   = organize_plot( dataset_name, policy_7,budget,"policy_7")
# shade_df_8   = organize_plot( dataset_name, policy_8,budget,"policy_8")
# shade_df_9   = organize_plot( dataset_name, policy_9,budget,"policy_9")
# shade_df_10   = organize_plot( dataset_name, policy_10,budget,"policy_10")
# shade_df_11   = organize_plot( dataset_name, policy_11,budget,"policy_11")
shade_df_12   = organize_plot( dataset_name, policy_12,budget,"policy_12")
shade_df_13   = organize_plot( dataset_name, policy_13,budget,"policy_13")
shade_df_14   = organize_plot( dataset_name, policy_14,budget,"policy_14")
shade_df_15   = organize_plot( dataset_name, policy_15,budget,"policy_15")
shade_df_16   = organize_plot( dataset_name, policy_16,budget,"policy_16")
shade_df_17   = organize_plot( dataset_name, policy_17,budget,"policy_17")
shade_df_18  = organize_plot( dataset_name, policy_18,budget,"policy_18")
shade_df_19   = organize_plot( dataset_name, policy_19,budget,"policy_19")
shade_df_20  = organize_plot( dataset_name, policy_20,budget,"policy_20")
shade_df_21   = organize_plot( dataset_name, policy_21,budget,"policy_21")
shade_df_22   = organize_plot( dataset_name, policy_22,budget,"policy_22")
shade_df_cams  =  organize_plot(dataset_name, CAMS, budget,      "CAMS")

shade_df=shade_df_cams

#shade_df=shade_df.append(shade_df_cams_max)
shade_df=shade_df.append(shade_df_0)#best policy cumuative loss: 12
shade_df=shade_df.append(shade_df_1)#13.32
shade_df=shade_df.append(shade_df_2)#13.54
shade_df=shade_df.append(shade_df_3)#18
shade_df=shade_df.append(shade_df_4)#14
shade_df=shade_df.append(shade_df_5)#18.6

# shade_df=shade_df.append(shade_df_12)
# shade_df=shade_df.append(shade_df_13)
# shade_df=shade_df.append(shade_df_14)
# shade_df=shade_df.append(shade_df_15)
# shade_df=shade_df.append(shade_df_16)
# shade_df=shade_df.append(shade_df_17)
# shade_df=shade_df.append(shade_df_18)
# shade_df=shade_df.append(shade_df_19)
# shade_df=shade_df.append(shade_df_20)
# shade_df=shade_df.append(shade_df_21)
#shade_df=shade_df.append(shade_df_22)#40
#shade_df=shade_df.append(shade_df_23)


plt.figure(figsize=(10, 10), dpi=300)

#    sns.set(font_scale = 5)
#sns.lineplot(x="budget_fixed", y="c_regret", hue="method",data=shade_df_cams,ci=63, color="grey", linewidth=1)

line_=sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_0"],ci=63, label = "best policy", color="purple",linewidth=3)
sns.lineplot(x="budget_fixed",  y="c_regret", data=shade_df[shade_df["method"]=="policy_1"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed",label = "top sub-optimal policies", y="c_regret", data=shade_df[shade_df["method"]=="policy_2"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_3"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_4"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_5"],ci=63, color="grey", linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_12"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_13"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_14"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_15"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_16"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_17"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_18"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_19"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_20"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_21"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_22"],ci=63, color="grey", linewidth=1)
#sns.lineplot(x="budget_fixed", y="c_regret", data=shade_df[shade_df["method"]=="policy_23"],ci=63, color="grey", linewidth=1)


sns.lineplot(x="budget_fixed", y="c_regret", label = n_CAMS, data=shade_df[shade_df["method"]==n_CAMS],color=my_pal[n_CAMS],ci=63, linewidth=4)

plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.xlabel("Query cost", fontsize=30)
# plt.ylabel("Cumulative loss", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21,title=None)
plt.legend("")

plt.savefig("./task6/"+dataset_name + "_task6_policy_only.png", bbox_inches='tight', pad_inches=0.01)
plt.savefig("./task6/"+dataset_name + "_task6_policy_only.pdf", bbox_inches='tight', pad_inches=0.01)


#save legend
fig = plt.figure(figsize=(10, 10), dpi=300)
handles,labels= line_.get_legend_handles_labels()

fig.legend(handles,labels,ncol=8, loc='center')
fig.savefig("./task6/" +'legend_task6_policy_only.png', bbox_inches='tight', pad_inches=0)
fig.savefig("./task6/" +'legend_task6_policy_only.pdf', bbox_inches='tight', pad_inches=0)




#############################################################################################
#CIFAR10

dataset_name="CIFAR10"
budget=100

policy_2="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[2]"
policy_3="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[3]"
policy_4="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[4]"
policy_5="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[5]"
#best policy
policy_11="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[11]"
policy_51="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[51]"
policy_60="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[60]"
policy_69="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[69]"
policy_79="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[79]"
policy_82="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[82]"
policy_83="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000010000_policy[83]"

CAMS="cifar_contextual_streamsize10000_numreals10"+time+"_which_methods00000001000_policy[6]"

shade_df=[]
shade_df_2   = organize_plot( dataset_name, policy_2, budget,"policy_2")
# shade_df_3   = organize_plot( dataset_name, policy_3, budget,"policy_3")
shade_df_4   = organize_plot( dataset_name, policy_4, budget,"policy_4")
shade_df_5   = organize_plot( dataset_name, policy_5, budget,"policy_5")
shade_df_11   = organize_plot( dataset_name, policy_11, budget,"policy_11")

shade_df_51   = organize_plot( dataset_name, policy_51, budget,"policy_51")
shade_df_60   = organize_plot( dataset_name, policy_60, budget,"policy_60")
shade_df_69   = organize_plot( dataset_name, policy_69, budget,"policy_69")
shade_df_79   = organize_plot( dataset_name, policy_79, budget,"policy_79")
shade_df_82   = organize_plot( dataset_name, policy_82, budget,"policy_82")
shade_df_83   = organize_plot( dataset_name, policy_83, budget,"policy_83")
shade_df_cams  =  organize_plot(dataset_name, CAMS, budget,   "CAMS")


shade_df=shade_df_cams
shade_df=shade_df.append(shade_df_2)
# shade_df=shade_df.append(shade_df_3)
shade_df=shade_df.append(shade_df_4)
shade_df=shade_df.append(shade_df_5)
shade_df=shade_df.append(shade_df_11)
shade_df=shade_df.append(shade_df_51)
shade_df=shade_df.append(shade_df_60)
shade_df=shade_df.append(shade_df_69)
shade_df=shade_df.append(shade_df_79)
shade_df=shade_df.append(shade_df_82)
shade_df=shade_df.append(shade_df_83)


fig, ax = plt.subplots(figsize=(10, 10), dpi=300)

#    sns.set(font_scale = 5)
#sns.lineplot(x="budget_fixed", y="c_regret", hue="method",data=shade_df_cams,ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_0"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_1"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_2"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_3"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_4"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_5"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_6"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_7"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_8"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_9"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_10"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_11"],ci=63, label = "best policy",color="purple", linewidth=3)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_12"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_13"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_14"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_15"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_16"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_17"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_18"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_19"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_20"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_21"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_22"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_23"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_24"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_25"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_26"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_27"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_28"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_29"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_30"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_41"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_42"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_43"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_44"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_45"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_46"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_47"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_48"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_49"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_50"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_61"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_62"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_63"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_64"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_65"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_66"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_67"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_68"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_69"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_70"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_71"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_72"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_73"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_74"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_75"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_76"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_77"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_78"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_79"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_80"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_81"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_82"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_83"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_84"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_85"],ci=63, color="grey", linewidth=1)

sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_165"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_166"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_167"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_168"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_169"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_170"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_171"],ci=63, color="grey", linewidth=1)
sns.lineplot(x="budget_fixed", y="c_regret",  data=shade_df[shade_df["method"]=="policy_172"],ci=63, color="grey", linewidth=1)

#sns.lineplot(x="budget_fixed", y="c_regret", label = "CAMS_MAX", data=shade_df[shade_df["method"]=="CAMS_MAX"],color="k",ci=63, linewidth=2)
sns.lineplot(x="budget_fixed", y="c_regret", label = n_CAMS, data=shade_df[shade_df["method"]==n_CAMS],color=my_pal[n_CAMS],ci=63, linewidth=4)
ax.set_ylim(2300,2700)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.xlabel("Query cost", fontsize=30)
# plt.ylabel("Cumulative loss", fontsize=30)
plt.ylabel("", fontsize=30)
plt.legend(loc=2)
plt.legend(fontsize=21,title=None)
plt.legend("")
plt.savefig("./task6/"+dataset_name + "_task6_policy_only.png", bbox_inches='tight', pad_inches=0.01)
plt.savefig("./task6/"+dataset_name + "_task6_policy_only.pdf", bbox_inches='tight', pad_inches=0.01)

print("completed!")
