import unittest
import os

from bbo.datasets.hpob_dataset import DatasetBase, load_hpob_datasets


if os.getenv('HPOB_ROOT_DIR') is None:
    os.environ['HPOB_ROOT_DIR'] = os.path.expanduser('~/dataset/hpob')


class HPOBDatasetTest(unittest.TestCase):
    def test_dataset_base(self):
        root_dir = os.getenv('HPOB_ROOT_DIR')
        dataset_dir = 'hpob-data'
        dataset_base = DatasetBase(os.path.join(root_dir, dataset_dir))

    def test_load_datasets(self):
        root_dir = os.getenv('HPOB_ROOT_DIR')
        dataset_dir = 'hpob-data'
        train_dataset, test_dataset, validation_datset = load_hpob_datasets(os.path.join(root_dir, dataset_dir))
        self.assertTrue(len(test_dataset['4796']['3549']) > 0)

    def test_print_info(self):
        root_dir = os.getenv('HPOB_ROOT_DIR')
        dataset_dir = 'hpob-data'
        train_dataset, test_dataset, validation_datset = load_hpob_datasets(os.path.join(root_dir, dataset_dir))