def X_transform(X, lb, ub, device='cpu'):
    lb, ub = lb.to(device), ub.to(device)
    X = (X - lb) / (ub - lb)
    return X.double().to(device)


def Y_transform(Y, mean=None, std=None, device='cpu'):
    if mean is None or std is None:
        mean, std = Y.mean(), Y.std()
    Y = (Y - mean) / (std + 1e-6)
    return Y.double().to(device), mean, std