import random


def weighted_single_eval_pos_sampler(max_len):
    single_eval_pos = random.choices(range(max_len), [(1 / (max_len-i)) for i in range(max_len)])[0]
    return single_eval_pos


def uniform_single_eval_pos_sampler(max_len, start=None, end=None):
    start = 0 if start is None else start
    end = max_len if end is None else end
    single_eval_pos = random.choices(range(start, end))[0]
    return single_eval_pos