import os

def get_log_dir_index(out_dir):
    dirs = [x[0] for x in os.listdir(out_dir)]
    if '.' in dirs:  # minor change for .ipynb
        dirs.remove('.')
    log_dir_index = '_' + str(len(dirs))

    return log_dir_index

class Config:
    def __init__(self, args):
        # create dirs
        self.base_dir = 'results'
        os.makedirs(self.base_dir, exist_ok=True)

        # common
        self.algorithm = args.algorithm
        self.seed = args.seed

        self.dataset = args.dataset
        self.query_scope = args.query_scope
        self.context_len = args.context_len
        self.context_num = args.context_num

        self.embedding_model = args.embedding_model

        self.dsl = args.dsl

        self.alpha = args.alpha
        self.beta = args.beta
        self.gamma = args.gamma

        self.engine = args.engine
        self.temperature = args.temperature
        self.freq_penalty = args.freq_penalty
        self.max_tokens = args.max_tokens
        self.llm_cache_dir = args.llm_cache_dir

        index = get_log_dir_index(self.base_dir)
        self.cfg_dir = '%s/%s' % (self.base_dir, self.algorithm + "_" + self.dataset + index)
        os.makedirs(self.cfg_dir, exist_ok=True)
        self.result_dir = '%s/results' % self.cfg_dir
        self.log_dir = '%s/log' % self.cfg_dir
        os.makedirs(self.result_dir, exist_ok=True)
        os.makedirs(self.log_dir, exist_ok=True)