from dataclasses import dataclass

@dataclass
class SimpleRule:
    origin: str
    expansion: tuple

    def __hash__(self):
        return hash(str(self))

    def __str__(self):
        return self.to_lark()

    def to_lark(self):
        return f"{self.origin} : {' '.join(self.expansion)}"

    def to_bnf(self):
        return f"{self.origin} ::= {' '.join(self.expansion)}"

    def __eq__(self, __o: object) -> bool:
        if not isinstance(__o, SimpleRule):
            return False
        return str(self) == str(__o)