from dataclasses import dataclass
from typing import Collection
import re
from lark.lexer import TerminalDef

@dataclass
class LexerConf:
    terminals: Collection[TerminalDef]
    ignore: Collection[str]
    use_bytes: bool = False
    re_module = re
    g_regex_flags: int = 0

    def __post_init__(self):
        self.terminals_by_name = {t.name: t for t in self.terminals}
        assert len(self.terminals) == len(self.terminals_by_name)