from tableshift.core.features import FeatureList, Feature

NHIS_DIABETES_FEATURES = FeatureList(
    features=[
        Feature("YEAR", int, name_extended="Year of survey"),
        # Feature('SERIAL', int),
        # Feature('STRATA', int),
        # Feature('PSU', int),
        # Feature('NHISHID', object),
        # Feature('HHWEIGHT', float),
        Feature("REGION", int, name_extended="Region of residence"),
        # Feature('PERNUM', int),
        # Feature('NHISPID', object),
        # Feature('HHX', object),
        # Feature('FMX', float),
        # Feature('PX', float),
        # Feature('PERWEIGHT', float),
        # Feature('SAMPWEIGHT', float),
        # Feature('LONGWEIGHT', float),
        # Feature('PARTWEIGHT', float),
        # Feature('FWEIGHT', float),
        # Feature('ASTATFLG', int),
        # Feature('CSTATFLG', int),
        Feature("AGE", int, name_extended="age"),
        Feature(
            "SEX",
            int,
            name_extended="sex",
            value_mapping={
                1: "Male",
                2: "Female",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "MARSTCOHAB",
            int,
            name_extended="Marital status",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "Married, spouse present",
                2: "Married, spouse absent",
                3: "Married, spouse in household unknown",
                4: "Separated",
                5: "Divorced",
                6: "Widowed",
                7: "Living with partner",
                8: "Never married",
                9: "Unknown marital status",
            },
        ),
        Feature(
            "RACENEW",
            int,
            name_extended="Self-reported Race",
            value_mapping={
                100: "White only",
                200: "Black/African American only",
                300: "American Indian/Alaska Native only",
                400: "Asian only",
                500: "Other Race and Multiple Race",
                510: "Other Race and Multiple Race (2019-forward: Excluding American Indian/Alaska Native)",
                520: "Other Race",
                530: "Race Group Not Releasable",
                540: "Multiple Race",
                541: "Multiple Race (1999-2018: Including American Indian/Alaska Native)",
                542: "American Indian/Alaska Native and Any Other Race",
                997: "Unknown-Refused",
                998: "Unknown-Not ascertained",
                999: "Unknown-Don't Know",
            },
        ),
        Feature(
            "CITIZEN",
            int,
            name_extended="U.S. citizenship",
            value_mapping={
                1: "No, not U.S. citizen",
                2: "Yes, U.S. citizen",
                7: "Unknown--refused",
                8: "Unknown--not ascertained",
                9: "Unknown--don't know",
            },
        ),
        Feature(
            "EDUC",
            int,
            name_extended="Educational attainment",
            value_mapping={
                000: "Not in Universe (not asked/not applicable to this respondent)",
                100: "Grade 12 or less, no high school diploma or equivalent",
                101: "Grade 8 or less (no further detail)",
                102: "Never attended/kindergarten only",
                103: "Grades 1-11 (no further detail)",
                104: "Grade 1",
                105: "Grade 2",
                106: "Grade 3",
                107: "Grade 4",
                108: "Grade 5",
                109: "Grade 6",
                110: "Grade 7",
                111: "Grade 8",
                112: "Grade 9-12, no diploma (no further detail)",
                113: "Grade 9",
                114: "Grade 10",
                115: "Grade 11",
                116: "12th grade, no diploma",
                200: "High school diploma or GED",
                201: "High school graduate",
                202: "GED or equivalent",
                300: "Some college, no 4yr degree",
                301: "Some college, no degree",
                302: "AA degree: technical/vocational/occupational",
                303: "AA degree: academic program",
                400: "Bachelor's degree (BA,AB,BS,BBA)",
                500: "Master's, Professional, or Doctoral Degree",
                501: "Master's degree (MA,MS,Med,MBA)",
                502: "Professional (MD,DDS,DVM,JD)",
                503: "Doctoral degree (PhD, EdD)",
                504: "Other degree",
                505: "Professional School or Doctoral degree, topcoded (MD, DDS, DVM, JD, PhD, EdD)",
                996: "No degree, years of education unknown",
                997: "Unknown--refused",
                998: "Unknown--not ascertained",
                999: "Unknown--don't know",
            },
        ),
        Feature(
            "EMPSTAT",
            int,
            name_extended="Employment status in past 1 to 2 weeks",
            value_mapping={
                000: "Not in Universe (not asked/not applicable to this respondent)",
                100: "Employed",
                110: "Working",
                111: "Working for pay at job/business",
                112: "Working, w/out pay, at job/business",
                120: "With job, but not at work",
                121: "With job, not at work: not laid-off, not looking",
                122: "With job, not at work: looking",
                200: "Not employed",
                210: "Unemployed",
                211: "Unemployed: On layoff",
                212: "Unemployed: On layoff and looking",
                213: "Unemployed: Unk if looking or laid off",
                214: "Unemployed: Looking or on layoff",
                215: "Unemployed: Have job to return to",
                216: "Unemployed: Had job during the round",
                217: "Unemployed: No job during reference period",
                220: "Not in labor force",
                900: "Unknown-all causes",
                997: "Unknown-refused",
                998: "Unknown-not ascertained",
                999: "Unknown-don't know",
            },
        ),
        Feature(
            "OCC1995",
            float,
            name_extended="Occupation",
            value_mapping={
                0000.0: "Not in Universe (not asked/not applicable to this respondent)",
                0100.0: "Executive, Administrative, and Managerial Occupations",
                0101.0: "Managers and administrators, except farm",
                0102.0: "Officials and administrators, public administration",
                0103.0: "Managers and administrators, except public administration",
                0104.0: "Management related occupations",
                0200.0: "Professional Specialty Occupations",
                0210.0: "Engineers, Architechts, Surveyors, and Scientists:",
                0211.0: "Engineers, scientists, and technicians",
                0212.0: "Engineers and architects",
                0213.0: "Engineers",
                0214.0: "Architects and surveyors",
                0215.0: "Scientists",
                0216.0: "Natural mathematical and computer scientists",
                0220.0: "Health Assessment, Diagnosing, and Treating Occupations:",
                0221.0: "Health workers",
                0222.0: "Health diagnosing occupations",
                0223.0: "Health assessment and treating occupations",
                0230.0: "Teachers, Librarians, Archivists, and Curators:",
                0231.0: "Teachers, librarians and counselors",
                0232.0: "Teachers, including professors and instructors",
                0240.0: "All other professional specialty occupations",
                0241.0: "All other professional, technical, and kindred workers",
                0242.0: "Writers, artists, entertainers and athletes",
                0243.0: "Other professional specialty occupations",
                0300.0: "Technicians and Related Support Occupations",
                0301.0: "Health technologists and technicians",
                0302.0: "Engineering and science technicians",
                0303.0: "Technologists, technicians except health",
                0400.0: "Sales Occupations:",
                0401.0: "Sales workers",
                0402.0: "Supervisors and proprietors",
                0403.0: "Sales representatives, commodities and finance",
                0404.0: "Other sales",
                0500.0: "Administrative Support Occupations, Including Clerical",
                0501.0: "Mail carriers, baggagemen, teleg. messengers",
                0502.0: "Stenos, typists, secretaries, receptionist",
                0503.0: "Other clerical",
                0504.0: "Financial records processing occupations",
                0505.0: "Bookkeepers",
                0506.0: "Office machine operators",
                0507.0: "Computer equipment operators",
                0508.0: "All other clerical workers",
                0509.0: "Other administrative support",
                0600.0: "Private Household Occupations:",
                0601.0: "Private household workers",
                0602.0: "Housekeepers, laundresses, baby sitters, etc.",
                0700.0: "Protective Service Occupations",
                0701.0: "Protective service",
                0702.0: "Police and firefighters",
                0703.0: "Other protective service occupations",
                0800.0: "Service Occupations, Except Protective and Household",
                0801.0: "All other service workers",
                0802.0: "Food service",
                0803.0: "Cleaning and building service",
                0804.0: "Health and personal service",
                0805.0: "Health service",
                0806.0: "Personal service",
                0900.0: "Farm Operators and Managers:",
                0901.0: "Farmers and farm managers",
                0902.0: "Farmers",
                0903.0: "Farm managers",
                1000.0: "Other Agricultural and Related Occupations:",
                1001.0: "Farm workers and other agricultural workers",
                1002.0: "Farm laborers and farm foremen",
                1003.0: "Farm laborers",
                1004.0: "Forestry and fishing occupations",
                1100.0: "Mechanics and Repairers Occupation",
                1101.0: "Mechanics and repairers",
                1102.0: "Construction, including carpenters",
                1103.0: "Machinists, mechanics, repairment, and metal craftsmen",
                1200.0: "Construction and Extractive Trades Occupation",
                1201.0: "Construction and extractive trades",
                1202.0: "Apprentice, construction",
                1203.0: "Carpenters",
                1204.0: "Other construction craftsmen",
                1205.0: "Mine operatives and laborers",
                1300.0: "Precision Production Occupations:",
                1301.0: "Precision production occupations",
                1302.0: "Metal craftsmen, except mechanics",
                1303.0: "All other craftsmen",
                1304.0: "Apprentice, machinists, mechanics, metals",
                1400.0: "Machine Operators, Assemblers, and Inspectors",
                1401.0: "Operatives, except transport",
                1402.0: "Machine operators and tenderers, except precision",
                1403.0: "Fabricators, assemblers, inspectors, and samplers",
                1500.0: "Transportation and Material Moving Occupations",
                1501.0: "Transport equipment operatives",
                1502.0: "Motor vehicle operators",
                1503.0: "Other transportation, except motor vehicles",
                1504.0: "Material moving equipment operators",
                1505.0: "Construction laborers",
                1506.0: "Freight, stock and material handlers",
                1507.0: "All other operatives",
                1508.0: "Laborers, except farm",
                1509.0: "All other laborers except farm and mine",
                1600.0: "Military",
                7777.0: "Unknown-refused",
                8888.0: "Unknown-not ascertained",
                9999.0: "Unknown-don't know",
            },
        ),
        Feature(
            "IND1995",
            float,
            name_extended="Industry",
            value_mapping={
                0000.0: "Not in Universe (not asked/not applicable to this respondent)",
                0100.0: "Agriculture",
                0200.0: "Forestry and Fisheries",
                0300.0: "Mining",
                0400.0: "Construction",
                0500.0: "Nondurable products",
                0510.0: "Food and kindred products",
                0520.0: "Textile mill and finished textile products",
                0530.0: "Printing, publishing, and allied industries",
                0540.0: "Chemicals and allied products:",
                0600.0: "Durable Goods",
                0610.0: "Furniture, lumber, and wood",
                0620.0: "Metal industries:",
                0621.0: "Primary metal industries",
                0622.0: "Fabricated metal industries, including ordnance",
                0630.0: "Machinery, except electrical machinery",
                0640.0: "Electrical machinery, equipment, and supplies",
                0650.0: "Transportation equipment",
                0660.0: "All other and unspecified products",
                0661.0: "Other nondurable products",
                0662.0: "Other durable products",
                0700.0: "Transportation",
                0710.0: "Railroads",
                0720.0: "All other transportation",
                0721.0: "Trucking service and warehousing",
                0722.0: "All other transportation except trucking service and warehousing",
                0800.0: "Communications",
                0900.0: "Utilities and sanitary",
                1000.0: "Wholesale trade",
                1100.0: "Eating and drinking places",
                1200.0: "Other retail trade",
                1210.0: "General merchandise stores",
                1220.0: "Food, bakery, and dairy stores",
                1230.0: "Automotive dealers and gasoline stations",
                1240.0: "Other and unspecified retail trade",
                1300.0: "Finance, insurance, and real estate",
                1310.0: "Banking and credit agencies",
                1320.0: "Insurance, real estate, and other finance",
                1400.0: "Business services",
                1500.0: "Repair services",
                1600.0: "Private households",
                1700.0: "Other personal services",
                1800.0: "Entertainment and recreation services",
                1900.0: "Medical and other health services",
                1910.0: "Hospitals",
                1920.0: "Health services, except hospitals",
                2000.0: "Educational services",
                2010.0: "Elementary and secondary schools and colleges",
                2020.0: "Other educational services",
                2100.0: "Other miscellaneous services",
                2110.0: "Social services, religious and membership organizations",
                2120.0: "Legal, engineering and other professional services",
                2200.0: "Public Aadministration",
                2300.0: "Armed forces",
                7777.0: "Unknown-refused",
                8888.0: "Unknown-not ascertained",
                9999.0: "Unknown-don't know",
            },
        ),
        Feature(
            "POORYN",
            float,
            name_extended="Above or below poverty threshold",
            value_mapping={
                1: "At or above poverty threshold",
                2: "Below poverty threshold",
                9: "Unk (1997+: incl. Undefined)",
            },
        ),
        Feature(
            "INCFAM07ON",
            float,
            name_extended="Total combined family income",
            value_mapping={
                10: "0 - $49,999 (no further detail)",
                11: "0 - $34,999",
                12: "35,000 - $49,999",
                20: "50,000 and over (no further detail; available 2007-2013)",
                21: "50,000 - $99,999 (no further detail)",
                22: "50,000 - $74,999",
                23: "75,000 - $99,999",
                24: "100,000 and over",
                96: "Undefined",
                99: "Unknown",
            },
        ),
        Feature(
            "HEALTH",
            int,
            name_extended="Health status",
            value_mapping={
                1: "Excellent",
                2: "Very Good",
                3: "Good",
                4: "Fair",
                5: "Poor",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature("BMICALC", float, name_extended="Body Mass Index"),
        Feature(
            "USUALPL",
            int,
            name_extended="Has usual place for medical care",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "There is no place or No",
                2: "Yes, has a usual place or Yes",
                3: "There is more than one place",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "TYPPLSICK",
            int,
            name_extended="Kind of usual place for medical care",
            value_mapping={
                000: "Not in Universe (not asked/not applicable to this respondent)",
                100: "Doctor's office, clinic, or health center",
                110: "Clinic or health center",
                111: "Health center",
                112: "Public health clinic",
                113: "Clinic, unspecified type",
                114: "Community/immigrant/rural clinic",
                115: "Company or school clinic/center",
                116: "Urgent care/walk-in clinic",
                117: "Migrant clinic",
                118: "Rural health center",
                119: "Community or family health center",
                120: "Doctor's office or HMO",
                121: "Doctor's office",
                122: "HMO",
                123: "Doctor's clinic",
                124: "Private doctor's office in hospital",
                130: "Doctor's office or health center",
                200: "Hospital emergency room",
                300: "Hospital outpatient department",
                310: "County/city/public/county hospital outpatient",
                320: "Private/other hospital outpatient clinic",
                400: "Some other place",
                410: "Psychiatric hospital/clinic",
                420: "VA hospital/clinic",
                430: "Military health care facility",
                440: "Military or VA health care facility",
                450: "VA Medical Center or VA outpatient clinic",
                460: "At home",
                470: "Non-hospital place",
                480: "Other places (1985: Includes known HMOs)",
                500: "Doesn't go to one place most often",
                997: "Unknown-refused",
                998: "Unknown-not ascertained",
                999: "Unknown-don't know",
            },
        ),
        Feature(
            "YBARCARE",
            int,
            name_extended="Needed but couldn't afford medical care, past 12 months",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        # Feature('DIABETICAGE', int, name_extended='Age first diagnosed with diabetes'),
        Feature(
            "diabetes", int, name_extended="Diagnosed with diabetes", is_target=True
        ),
        Feature(
            "CHOLCHEK1YR",
            float,
            name_extended="Had cholesterol checked by health professional, past 12 months",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "CHOLMEDNOW",
            float,
            name_extended="Now taking prescribed medicine to lower cholesterol",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "HYP2TIME",
            int,
            name_extended="Ever told had hypertension on 2+ visits",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "CHEARTDIEV",
            int,
            name_extended="Ever told had coronary heart disease",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown--refused",
                8: "Unknown--not ascertained",
                9: "Unknown--don't know",
            },
        ),
        Feature(
            "CHOLHIGHYR",
            float,
            name_extended="Had high cholesterol, past 12 months",
            value_mapping={
                0.0: "Not in Universe (not asked/not applicable to this respondent)",
                1.0: "No",
                2.0: "Yes",
                7.0: "Unknown-refused",
                8.0: "Unknown-not ascertained",
                9.0: "Unknown-don't know",
            },
        ),
        Feature(
            "CONGHARTEV",
            float,
            name_extended="Ever told had congenital heart disease",
            value_mapping={
                0.0: "Not in Universe (not asked/not applicable to this respondent)",
                1.0: "No or not mentioned",
                2.0: "Yes",
                7.0: "Unknown-refused",
                8.0: "Unknown-not ascertained",
                9.0: "Unknown-don't know",
            },
        ),
        Feature(
            "HEARTATTEV",
            int,
            name_extended="Ever told had heart attack",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown--refused",
                8: "Unknown--not ascertained",
                9: "Unknown--don't know",
            },
        ),
        Feature(
            "HYPERTENEV",
            int,
            name_extended="Ever told had hypertension",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "KIDNEYWKYR",
            float,
            name_extended="Told had weak/failing kidneys, past 12 months",
            value_mapping={
                0.0: "Not in Universe (not asked/not applicable to this respondent)",
                1.0: "No",
                2.0: "Yes",
                7.0: "Unknown-refused",
                8.0: "Unknown-not ascertained",
                9.0: "Unknown-don't know",
            },
        ),
        Feature(
            "LIVERCHRON",
            float,
            name_extended="Ever had any chronic liver condition",
            value_mapping={
                0.0: "Not in Universe (not asked/not applicable to this respondent)",
                1.0: "No",
                2.0: "Yes",
                7.0: "Unknown-refused",
                8.0: "Unknown-not ascertained",
                9.0: "Unknown-don't know",
            },
        ),
        Feature(
            "STROKEV",
            int,
            name_extended="Ever told had a stroke",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "ALCAMT",
            float,
            name_extended="Average number of drinks on days drank",
            value_mapping={
                00.0: "Not in Universe (not asked/not applicable to this respondent)",
                01.0: "1 drink or less",
                02.0: "2 drinks",
                03.0: "3 drinks",
                04.0: "4 drinks",
                05.0: "5 drinks",
                06.0: "6 drinks",
                07.0: "7 drinks",
                08.0: "8 drinks",
                09.0: "9 drinks",
                10.0: "10 drinks",
                11.0: "11 drinks",
                12.0: "12 drinks",
                13.0: "13 drinks",
                14.0: "14 drinks",
                15.0: "15 drinks",
                16.0: "16 drinks",
                17.0: "17 drinks",
                18.0: "18 drinks",
                19.0: "19 drinks",
                20.0: "20 drinks",
                21.0: "21 drinks",
                22.0: "22 drinks",
                23.0: "23 drinks",
                24.0: "24 drinks",
                25.0: "25 drinks",
                26.0: "26 drinks",
                27.0: "27 drinks",
                28.0: "28 drinks",
                29.0: "29 drinks",
                30.0: "30 drinks",
                31.0: "31 drinks",
                32.0: "32 drinks",
                33.0: "33 drinks",
                34.0: "34 drinks",
                35.0: "35 drinks",
                36.0: "36 drinks",
                37.0: "37 drinks",
                38.0: "38 drinks",
                39.0: "39 drinks",
                40.0: "40 drinks",
                41.0: "41 drinks",
                42.0: "42 drinks",
                43.0: "43 drinks",
                44.0: "44 drinks",
                45.0: "45 drinks",
                46.0: "46 drinks",
                47.0: "47 drinks",
                48.0: "48 drinks",
                49.0: "49 drinks",
                50.0: "50 drinks",
                51.0: "51 drinks",
                52.0: "52 drinks",
                53.0: "53 drinks",
                54.0: "54 drinks",
                55.0: "55 drinks",
                56.0: "56 drinks",
                57.0: "57 drinks",
                58.0: "58 drinks",
                59.0: "59 drinks",
                60.0: "60 drinks",
                61.0: "61 drinks",
                62.0: "62 drinks",
                63.0: "63 drinks",
                64.0: "64 drinks",
                65.0: "65 drinks",
                66.0: "66 drinks",
                67.0: "67 drinks",
                68.0: "68 drinks",
                69.0: "69 drinks",
                70.0: "70 drinks",
                71.0: "71 drinks",
                72.0: "72 drinks",
                73.0: "73 drinks",
                74.0: "74 drinks",
                75.0: "75 drinks",
                76.0: "76 drinks",
                77.0: "77 drinks",
                78.0: "78 drinks",
                79.0: "79 drinks",
                80.0: "80 drinks",
                81.0: "81 drinks",
                82.0: "82 drinks",
                83.0: "83 drinks",
                84.0: "84 drinks",
                85.0: "85 drinks",
                86.0: "86 drinks",
                87.0: "87 drinks",
                88.0: "88 drinks",
                89.0: "89 drinks",
                90.0: "90 drinks",
                91.0: "91 drinks",
                92.0: "92 drinks",
                93.0: "93 drinks",
                94.0: "94 drinks",
                95.0: "95+ drinks",
                96.0: "Inconsistent",
                97.0: "Unknown - refused",
                98.0: "Unknown - not ascertained",
                99.0: "Unknown - don't know",
            },
        ),
        Feature(
            "ALCSTAT1",
            float,
            name_extended="Alcohol drinking status: Recode",
            value_mapping={
                0.0: "Not in Universe (not asked/not applicable to this respondent)",
                1.0: "Lifetime abstainer (lt 12 drinks in life)",
                2.0: "Former drinker (no drinks past year)",
                3.0: "Current drinker (1+ drinks past year)",
                9.0: "Drinking status unknown",
            },
        ),
        Feature(
            "ALCDAYSWK",
            float,
            name_extended="Frequency drank alcohol in past year: Days per week",
            value_mapping={
                00.0: "Less than one day per week",
                10.0: "1 day per week",
                20.0: "2 days per week",
                30.0: "3 days per week",
                40.0: "4 days per week",
                50.0: "5 days per week",
                60.0: "6 days per week",
                70.0: "7 days per week",
                80.0: "Did not drink in past year",
                95.0: "Inconsistent",
                96.0: "Not in Universe (not asked/not applicable to this respondent)",
                97.0: "Unknown-refused",
                98.0: "Unknown-not ascertained",
                99.0: "Unknown-don't know",
            },
        ),
        Feature(
            "SMOKEV",
            int,
            name_extended="Ever smoked 100 cigarettes in life",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "No",
                2: "Yes",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "SMOKFREQNOW",
            int,
            name_extended="Smoke every day, some days, or not at all",
            value_mapping={
                0: "Not in Universe (not asked/not applicable to this respondent)",
                1: "Not at all",
                2: "Some days",
                3: "Every day",
                7: "Unknown-refused",
                8: "Unknown-not ascertained",
                9: "Unknown-don't know",
            },
        ),
        Feature(
            "MOD10FWK",
            float,
            name_extended="Frequency of moderate activity 10+ minutes: Times per week",
            value_mapping={
                00.0: "Not in Universe (not asked/not applicable to this respondent)",
                **{float(x): float(x) for x in range(1, 93)},
                93.0: "Extreme value",
                94.0: "Less than once per week",
                95.0: "Never",
                96.0: "Unable to do this activity",
                97.0: "Unknown-refused",
                98.0: "Unknown-not ascertained",
                99.0: "Unknown-don't know",
            },
        ),
        Feature(
            "VIG10FWK",
            float,
            name_extended="Frequency of vigorous activity 10+ minutes: Times per week",
            value_mapping={
                00.0: "Not in Universe (not asked/not applicable to this respondent)",
                **{float(x): float(x) for x in range(1, 93)},
                93.0: "Extreme value",
                94.0: "Less than once per week",
                95.0: "Never",
                96.0: "Unable to do this activity",
                97.0: "Unknown-refused",
                98.0: "Unknown-not ascertained",
                99.0: "Unknown-don't know",
            },
        ),
        Feature(
            "POVERTY",
            int,
            name_extended="Ratio of family income to poverty threshold)",
            value_mapping={
                10: "Less than 1.0",
                11: "Under 0.50",
                12: "0.50 to 0.74",
                13: "0.75 to 0.99",
                14: "Less than 1.0 (no other detail)",
                20: "1.00 to 1.99",
                21: "1.00 to 1.24",
                22: "1.25 to 1.49",
                23: "1.50 to 1.74",
                24: "1.75 to 1.99",
                25: "1.00 - 1.99 (no further detail)",
                30: "2.00 and over",
                31: "2.00 to 2.49",
                32: "2.50 to 2.99",
                33: "3.00 to 3.49",
                34: "3.50 to 3.99",
                35: "4.00 to 4.49",
                36: "4.50 to 4.99",
                37: "5.00 and over",
                38: "2.00 and over (no other detail)",
                98: "Undefinable",
                99: "Unknown",
            },
        ),
    ]
)
DHS_DIABETES_FEATURES = FeatureList(
    features=[
        # Feature('SAMPLE', int),
        # Feature('SAMPLESTR', int),
        Feature(
            "COUNTRY",
            int,
            name_extended="country",
            value_mapping={
                4: "Afghanistan",
                24: "Angola",
                50: "Bangladesh",
                104: "Myanmar",
                108: "Burundi",
                116: "Cambodia",
                120: "Cameroon",
                140: "Central African Republic",
                144: "Sri Lanka",
                148: "Chad",
                178: "Congo Brazzaville",
                180: "Congo Democratic Republic",
                204: "Benin",
                231: "Ethiopia",
                288: "Ghana",
                320: "Guatemala",
                324: "Guinea",
                356: "India",
                384: "Cote d'Ivoire",
                400: "Jordan",
                404: "Kenya",
                426: "Lesotho",
                430: "Liberia",
                450: "Madagascar",
                454: "Malawi",
                466: "Mali",
                504: "Morocco",
                508: "Mozambique",
                516: "Namibia",
                524: "Nepal",
                562: "Niger",
                586: "Pakistan",
                566: "Nigeria",
                604: "Peru",
                646: "Rwanda",
                686: "Senegal",
                710: "South Africa",
                716: "Zimbabwe",
                729: "Sudan",
                748: "Eswatini",
                768: "Togo",
                788: "Tunisia",
                792: "Turkey",
                800: "Uganda",
                818: "Egypt",
                834: "Tanzania",
                854: "Burkina Faso",
                887: "Yemen",
                894: "Zambia",
                1: "Model",
            },
        ),
        Feature("YEAR", int),
        # Feature('IDHSPID', cat_dtype),
        # Feature('IDHSHID', cat_dtype),
        # Feature('DHSID', cat_dtype),
        # Feature('IDHSPSU', float),
        # Feature('IDHSSTRATA', float),
        # Feature('CASEID', cat_dtype),
        # Feature('HHID', cat_dtype),
        # Feature('PSU', float),
        # Feature('STRATA', float),
        # Feature('DOMAIN', float),
        # Feature('HHNUM', float),
        # Feature('CLUSTERNO', int),
        # Feature('LINENO', int),
        # Feature('PERWEIGHT', float),
        # Feature('POPWT', float),
        # Feature('AWFACTT', float),
        # Feature('AWFACTU', float),
        # Feature('AWFACTR', float),
        # Feature('AWFACTE', float),
        # Feature('AWFACTW', float),
        # Feature('DVWEIGHT', float),
        Feature(
            "URBAN",
            int,
            name_extended="Urban-rural status",
            value_mapping={
                1: "Urban",
                2: "Rural",
            },
        ),
        # Feature('GEO_BI2010_2016', float, name_extended='Benin regions',
        #         value_mapping={
        #             1.: "Atacora and Donga",
        #             2.: "Atlantique and Littoral",
        #             3.: "Borgu and Alibori",
        #             4.: "Mono and Couffo",
        #             5.: "Ouémé and Plateau",
        #             6.: "Zou and Collins",
        #         }),
        # Feature('GEO_NE1992_2012', float, name_extended='Burkina Faso regions',
        #         value_mapping={
        #             01.: "Boucle de Mouhoun",
        #             02.: "Cascades",
        #             03.: "Centre including Ouagadougou",
        #             04.: "Centre-Est",
        #             05.: "Centre-Nord",
        #             06.: "Centre-Ouest",
        #             07.: "Centre-Sud",
        #             08.: "Est",
        #             09.: "Hauts Basins",
        #             10.: "Nord",
        #             11.: "Plateau Central",
        #             12.: "Sahel",
        #             13.: "Sud-Ouest"
        #         }),
        # Feature('GEO_SN1986_2017', float,
        #         name_extended='Burundi regions',
        #         value_mapping={
        #             1.: "Bujumbura Mairie",
        #             2.: "Kayanza, Kirundo, Muyinga, Ngozi",
        #             3.: "Cankuzo, Gitega, Karusi, Muramvya, Ruyigi",
        #             4.: "Bubanza, Bujumbura Rural, Bururi, Cibitoke, Makamba, Mwaro, Rutana, Rumonge",
        #         }),
        # Feature('GEO_BI2016', float,
        #         name_extended='Burundi regions',
        #         value_mapping={
        #             01.: "Bubanza",
        #             02.: "Bujumbura Rural",
        #             03.: "Bururi",
        #             04.: "Cankuzo",
        #             05.: "Cibitoke",
        #             06.: "Gitega",
        #             07.: "Karusi",
        #             08.: "Kayanza",
        #             09.: "Kirundo",
        #             10.: "Makamba",
        #             11.: "Muramvya",
        #             12.: "Muyinga",
        #             13.: "Mwaro",
        #             14.: "Ngozi",
        #             15.: "Rutana",
        #             16.: "Ruyigi",
        #             17.: "Bujumbura Mairie",
        #             18.: "Rumonge",
        #         }),
        # Feature('GEO_NE2012', float,
        #         name_extended='Niger regions, 2012',
        #         value_mapping={
        #             1.: "Agadez",
        #             2.: "Diffa",
        #             3.: "Dosso",
        #             4.: "Maradi",
        #             5.: "Tahoua",
        #             6.: "Tillaben",
        #             7.: "Zinder",
        #             8.: "Niamey",
        #         }),
        # Feature('GEO_SN2010', float,
        #         name_extended='Senegal regions, 2010',
        #         value_mapping={
        #             01.: "Dakar",
        #             02.: "Ziguinchor",
        #             03.: "Diourbel",
        #             04.: "Saint-Louis",
        #             05.: "Tambacounda",
        #             06.: "Kaolack",
        #             07.: "Thiès",
        #             08.: "Louga",
        #             09.: "Fatick",
        #             10.: "Kolda",
        #             11.: "Matam",
        #             12.: "Kaffrine",
        #             13.: "Kedougou",
        #             14.: "Sedhiou",
        #         }),
        Feature("AGE", int, name_extended="age"),
        # Feature('AGE5YEAR', int),
        Feature(
            "RESIDENT",
            int,
            name_extended="Usual resident or visitor",
            value_mapping={
                1: "Usual resident",
                2: "Visitor",
                8: "Missing",
            },
        ),
        Feature(
            "RELIGION",
            float,
            name_extended="religion",
            value_mapping={
                0000.0: "NO RELIGION",
                1000.0: "MUSLIM",
                2000.0: "CHRISTIAN",
                2100.0: "Catholic",
                2200.0: "Orthodox",
                2300.0: "Protestant",
                2310.0: "Lutheran",
                2320.0: "Anglican",
                2330.0: "Presbyterian",
                2340.0: "Baptist/Seventh-day Adventist",
                2341.0: "Baptist",
                2342.0: "Seventh-day Adventist",
                2350.0: "Apostolic",
                2351.0: "New Apostolic",
                2360.0: "Salvation Army",
                2370.0: "Methodist",
                2380.0: "Pentecostal-based",
                2381.0: "Pentecostal",
                2382.0: "Celestial Church of Christ",
                2383.0: "Universal",
                2384.0: "Assemblies of God",
                2385.0: "Charismatic",
                2386.0: "Christian Revival Church",
                2390.0: "Other Protestant",
                2391.0: "Evangelical",
                2392.0: "Lesotho Evangelical Church",
                2393.0: "Kimbanguist (Congo, Democratic Republic and Republic)",
                2394.0: "Christian Zionist",
                2400.0: "Nontrinitarian",
                2410.0: "Jehovah's Witness",
                2411.0: "Adventist/Jehovah's Witness",
                2900.0: "Other Christian, country-specific",
                2901.0: "Mammon (Uganda)",
                2902.0: "Mana",
                3000.0: "BUDDHIST/NEO-BUDDHIST",
                3100.0: "Buddhist",
                4000.0: "HINDU",
                5000.0: "JEWISH",
                6000.0: "TRADITIONAL/SPIRITUAL/ANIMIST",
                6100.0: "Traditional",
                6200.0: "Spiritual",
                6300.0: "Animist",
                6400.0: "Specified Traditional",
                6401.0: "Donyi-Polo",
                6402.0: "Sanamahi",
                6403.0: "Vodun",
                7000.0: "OTHER (SPECIFIED)",
                7100.0: "Baha'i",
                7200.0: "Sikh",
                7300.0: "Zoroastrian",
                7400.0: "Jain",
                7900.0: "Country-specific other",
                7901.0: "Sect (Burundi)",
                7902.0: "Bundu dia Kongo (Congo, Democratic Republic)",
                7903.0: "Vuvamu (Congo, Democratic Republic)",
                7904.0: "Kirat Mundhum (Nepal)",
                7905.0: "Zephirin/Matsouaniste/Ngunza (Congo, Republic)",
                9000.0: "OTHER",
                9001.0: "Religion 1",
                9002.0: "Religion 2",
                9003.0: "Religion 3",
                9004.0: "Religion 4",
                9998.0: "Missing",
                9999.0: "NIU (not in universe)",
            },
        ),
        Feature(
            "MARSTAT",
            float,
            name_extended="Woman's current marital or union status",
            value_mapping={
                10.0: "Never married",
                11.0: "Unconsummated marriage",
                20.0: "Married or living together",
                21.0: "Married",
                22.0: "Living together",
                30.0: "Formerly in union",
                31.0: "Widowed",
                32.0: "Divorced",
                33.0: "Separated/not living together",
                34.0: "Deserted",
                98.0: "Missing",
            },
        ),
        Feature(
            "CHEB", int, name_extended="Total children ever born", na_values=(98, 99)
        ),
        Feature(
            "CURRWORK",
            float,
            name_extended="Currently working",
            value_mapping={
                00.0: "No",
                10.0: "Yes",
                11.0: "Yes, spontaneous",
                12.0: "Yes, prompted",
                98.0: "Missing",
                99.0: "NIU (not in universe)",
            },
        ),
        Feature(
            "WKCURRJOB",
            float,
            name_extended="Woman's occupation",
            value_mapping={
                00.0: "Not currently working",
                10.0: "Professional, technical, or managerial worker",
                20.0: "Clerical or Sales",
                21.0: "Clerical worker",
                22.0: "Sales worker",
                30.0: "Agricultural",
                31.0: "Self-employed agricultural worker",
                32.0: "Agricultural employee",
                40.0: "Household, domestic, and services",
                41.0: "Household and domestic worker",
                42.0: "Services worker",
                50.0: "Skilled and unskilled manual",
                51.0: "Skilled manual worker",
                52.0: "Unskilled manual worker",
                60.0: "Armed forces",
                96.0: "Other",
                97.0: "Don't know",
                98.0: "Missing",
                99.0: "NIU (not in universe)",
            },
        ),
        Feature(
            "WKEMPLOYWHEN",
            float,
            name_extended="Respondent works all year, seasonally, or occasionally",
            value_mapping={
                10.0: "All year",
                20.0: "Less than all year",
                21.0: "Most of the year",
                22.0: "Part of the year",
                23.0: "Seasonally",
                24.0: "Occasionally",
                25.0: "Temporary",
                29.0: "Other",
                98.0: "Missing",
                99.0: "NIU (not in universe)",
            },
        ),
        Feature(
            "WEALTHQ",
            float,
            name_extended="Household wealth index in quintiles",
            value_mapping={
                1.0: "Poorest",
                2.0: "Poorer",
                3.0: "Middle",
                4.0: "Richer",
                5.0: "Richest",
                8.0: "Missing",
            },
        ),
        Feature("WEALTHS", float, name_extended="Wealth index factor score"),
        Feature(
            "EDUCLVL",
            int,
            name_extended="Highest educational level",
            value_mapping={
                0: "No education",
                1: "Primary",
                2: "Secondary",
                3: "Higher",
                8: "Missing",
            },
        ),
        Feature(
            "YRSCHL",
            int,
            name_extended="Highest year of education in level",
            value_mapping={
                0: "0",
                1: "1",
                2: "2",
                3: "3",
                4: "4",
                5: "5",
                6: "6",
                7: "7",
                8: "8",
                9: "9",
                10: "10",
                11: "11",
                12: "12",
                13: "13",
                14: "14",
                15: "15",
                16: "16",
                17: "17",
                18: "18",
                19: "19",
                96: "Inconsistent",
                97: "Don't know",
                98: "Missing",
                99: "NIU (not in universe)",
            },
        ),
        Feature(
            "EDYRTOTAL",
            int,
            name_extended="Total years education",
            value_mapping={
                0: "0",
                1: "1",
                2: "2",
                3: "3",
                4: "4",
                5: "5",
                6: "6",
                7: "7",
                8: "8",
                9: "9",
                10: "10",
                11: "11",
                12: "12",
                13: "13",
                14: "14",
                15: "15",
                16: "16",
                17: "17",
                18: "18",
                19: "19",
                20: "20",
                21: "21",
                22: "22",
                23: "23",
                24: "24",
                25: "25",
                26: "26",
                27: "27",
                96: "Inconsistent",
                97: "Don't know",
                98: "Missing",
            },
        ),
        Feature(
            "ALFREQ",
            float,
            name_extended="Frequency of alcohol use",
            value_mapping={
                000.0: "Never",
                100.0: "Occasionally",
                110.0: "Less than once a week",
                111.0: "Less than once a month",
                112.0: "Monthly",
                113.0: "More than once a month",
                200.0: "Weekly",
                210.0: "More than once a week",
                211.0: "1 to 4 days a week",
                212.0: "More than 5 days a week",
                300.0: "Daily",
                400.0: "Other",
                990.0: "None in last 12 months",
                998.0: "Missing",
                999.0: "NIU(not in universe)",
            },
        ),
        # Feature('WEIGHTFEM', float,
        #         name_extended='Weight of woman (kilos)',
        #         na_values=(9994., 9995., 9996., 9997., 9998., 9999.)),
        # Feature('HEIGHTFEM', float,
        #         name_extended='Height of woman in centimeters',
        #         na_values=(9994., 9995., 9996., 9997., 9998., 9999.)),
        Feature(
            "BIOFBMI",
            float,
            name_extended="Body Mass Index (BMI) for respondents to the women's survey",
            na_values=(9995.0, 9998.0, 9999.0),
        ),
        Feature(
            "HIGHBP",
            float,
            name_extended="Adult has high blood pressure",
            value_mapping={
                0.0: "No",
                1.0: "Yes",
                8.0: "Don't know",
                9.0: "NIU (not in universe)",
            },
        ),
        Feature(
            "DIABETES",
            float,
            is_target=True,
            name_extended="Adult has diabetes",
            value_mapping={
                0.0: "No",
                1.0: "Yes",
                7.0: "Don't know",
                8.0: "Missing",
                9.0: "NIU (not in universe)",
            },
        ),
    ]
)
