%% a specific example

% n=3;
n = 1e2;
A =ones(n,1)';
b = 1;
Q = eye(n);
param.L_f = 1;
param.L_g = n;

%% parameter setting
param.epsilonf = 1e-4;
param.epsilong = 1e-4;
param.lam = 1;

%% function definition

% fun_f= @(x) sum_square(A1*x-b1)/2;
fun_f = @(x) x'*Q*x/2;
% fun_f = @(x) x'*x/2;
grad_f = @(x) Q*x;
fun_g = @(x) sum_square(A*x-b)/2;
grad_g = @(x) A'*(A*x-b);


%% initial point
x_init = randi(10,n,1);
maxiter = 1e3;

%% R-APM

param.maxiter=maxiter;
param.maxtime = 1;

disp('R-APM Algorithm starts')
[f_vecR,g_vecR,time_vecR,xlastR] = R_APM(fun_f,grad_f,grad_g,...
    fun_g,param,x_init);
disp('R-APM Solution Achieved!');

%% PB-APG

param.maxiter=maxiter;
param.maxtime = 1;

disp('PB-APG Algorithm starts')
[f_vecPB,g_vecPB,time_vecPB,xlastPB] = PB_APG(fun_f,grad_f,grad_g,...
    fun_g,param,x_init);
disp('PB-APG Solution Achieved!');


%% AGM-BiO
param.gstar = 0;
param.maxtime = 2;
% param.maxiter=1e3;
disp('AGM-BiO starts');
% [f_vecAB,g_vecAB,time_vecAB,x_AB,tsa_AB, X, Z] = AGM_BiO(fun_f,grad_f,grad_g,fun_g,...
%     @(x)TSA_LS(x,A3,b3),param,x_init);
[f_vecAB,g_vecAB,time_vecAB,x_AB] = AGM_BiO(fun_f,grad_f,grad_g,fun_g,...
    param,x_init);
disp('AGM-BiO Achieved!');

%% a-IRG Algorithm
% param.maxtime = time_vec1(end);
% param.maxiter=1e3;

disp('a-IRG Algorithm starts')
[f_vec2,g_vec2,time_vec2,xlast] = Alg_Projection(fun_f,grad_f,grad_g,...
    fun_g,param,x_init);
disp('a-IRG Solution Achieved!');

% %% BiG-SAM Algorithm
% param.eta_g = 1/eigs(A'*A,1);
% param.eta_f = 2/eigs(A1'*A1,1);
% param.gamma = 10;
% disp('BiG-SAM Algorithm starts');
% [f_vec3,g_vec3,time_vec3,xlast3,tsa_SAM] = BigSAM(fun_f,grad_f,grad_g,fun_g,@(x)TSA_LS(x,A3,b3),param,x_init);
% disp('BiG-SAM Solution Achieved!');

%% Bi-SG Algorithm
% param.eta_g = 1/eigs(A2'*A2,1);
% param.eta_f = 2/eigs(A1'*A1,1);
% param.gamma = 10;
% param.maxtime = time_vecR(end);
% param.maxiter=1e3;
disp('Bi-SG Algorithm starts');
[f_vecBSG,g_vecBSG,time_vecBSG,xlastBSG] = BiSG(fun_f,grad_f,grad_g,fun_g,param,x_init);
disp('Bi-SG Solution Achieved!');

% %% DBGD
% param.alpha = 1;
% param.beta = 1;
% param.stepsize = 5e-4;
% param.maxiter=1e8;
% param.maxtime = time_vec1(end);
% disp('DBGD Algorithm starts');
% [f_vec5,g_vec5,time_vec5,xlast5,tsa_DBGD] = DBGD(fun_f,grad_f,grad_g,fun_g,@(x)TSA_LS(x,A3,b3),param,x_init);
% disp('DBGD Solution Achieved!');
% 
% %% MNG
% param.maxtime = time_vec1(end);
% param.maxiter=length(time_vec1);
% param.M = eigs(A'*A,1);
% 
% [f_vec4,g_vec4,time_vec4,xlast4,tsa_MNG] = MNG(A1,b1,fun_g,grad_g,@(x)TSA_LS(x,A3,b3),param,A1\b1);

%% SEA Algorithm
% param.maxtime = time_vecR(end);
% param.maxiter=1e3;

disp('SEA Algorithm starts')
[f_vecS,g_vecS,time_vecS,xlastS] = SEA(fun_f,grad_f,grad_g,...
    fun_g,param,x_init,x_init,0);
disp('SEA Solution Achieved!');


%% extra var for bisec
fun_h = @(x) 0;

%% Initial bounds for Bisec-BiO method
% param.L_g = L_g;
% param.L_f = L_f;
% param.maxiter=5e5;
% param.epsilonf = epsilon_f/2;
% param.epsilong = epsilon_g/2;
param.epsilonf = 1e-4;
param.epsilong = 1e-4;
% tolerance of subproblem
param.tol = 1e-4;
tic;
[l,u,x_g,psi_g] = BisecBiO_initial(fun_f,fun_g,fun_h,grad_f,grad_g,x_init,param);
time_init0 = toc;


%% Bisec-BiO method
% param.maxiter=5e5;
% param.epsilonf = epsilon_f/2;
% param.epsilong = epsilon_g/2;
% param.epsilonf = 1e-8;
% param.epsilong = 1e-8;
param.L0 = param.L_g;
% tolerance of subproblem
% param.tol = 1e-8;
disp('Bisec-BiO method starts');
[f_vec0,g_vec0,time_vec0,x_hat] = BisecBiO(fun_f,fun_g,grad_g,l,u,x_g,psi_g,param);
f_vec0 = [fun_f(x_init);fun_f(x_g);f_vec0];g_vec0 = [fun_g(x_init);fun_g(x_g);g_vec0];
time_vec0 = time_init0 + time_vec0;
time_vec0 = [0;time_init0;time_vec0];
disp('Bisec-BiO method Achieved!');
% fprintf('constraint violation = %1.2e\n',fun_g(x_hat) - gstar);
% fprintf('gradient of lower level = %1.2e\n',norm(grad_g(x_hat)));

%% lower-level gap vs number of gradient eval
gstar = 0;
figure;
set(0,'defaulttextinterpreter','latex')
set(gcf,'DefaultLineLinewidth',5)
set(gcf,'DefaultLineMarkerSize',16);
set(gcf,'Position',[331,167,591,586])
maxiter = 2000;
param.maxtime = maxiter;
xaixs = [1:2:2000];
N_marker = 10;
time_idx = linspace(0,maxiter,N_marker);
marker_idx1 = zeros(N_marker,1);
marker_idx2 = zeros(N_marker,1);
marker_idx3 = zeros(N_marker,1);
marker_idx4 = zeros(N_marker,1);
marker_idx5 = zeros(N_marker,1);
marker_idxAGM = zeros(N_marker,1);
marker_idxR = zeros(N_marker,1);
marker_idxS = zeros(N_marker,1);
marker_idxBSG = zeros(N_marker,1);
marker_idxCB = zeros(N_marker,1);
marker_idxPB = zeros(N_marker,1);
marker_idxBB = zeros(N_marker,1);
for j=1:N_marker
%     [~,idx] = min(abs(time_vec1-time_idx(j)));
%     marker_idx1(j) = idx;
    [~,idx] = min(abs(xaixs-time_idx(j)));
    marker_idx2(j) = idx;
%     [~,idx] = min(abs(time_vec3-time_idx(j)));
%     marker_idx3(j) = idx;
%     [~,idx] = min(abs(time_vec4-time_idx(j)));
%    marker_idx4(j) = idx;
%    [~,idx] = min(abs(time_vec5-time_idx(j)));
%    marker_idx5(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxR(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxS(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxAGM(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxBSG(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxPB(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxBB(j) = idx;
%    [~,idx] = min(abs(time_vecCB-time_idx(j)));
%    marker_idxCB(j) = idx;
end

% semilogy(time_vec1,abs(g_vec1-gstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idx1);
% hold on;
% semilogy(time_vec4,abs(g_vec4-gstar),'d-','DisplayName','MNG','MarkerIndices', marker_idx4);
% hold on;

%semilogy(time_vec3,abs(g_vec3-gstar),'^-','DisplayName','BiG-SAM','MarkerIndices', marker_idx3);


semilogy(xaixs,abs(g_vec2-gstar),'s-','DisplayName','a-IRG','MarkerIndices', marker_idx2);
hold on;
% % semilogy(time_vecCB,abs(g_vecCB-gstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idxCB);
semilogy(xaixs,abs(g_vecBSG(1:1000)-gstar),'+-','DisplayName','Bi-SG','MarkerIndices', marker_idxBSG,"Color","#EDB120");
% %semilogy(time_vec5,abs(f_vec5-fstar),'>-','DisplayName','DBGD','MarkerIndices', marker_idx5);
semilogy(xaixs,abs(g_vecS-gstar),'>-','DisplayName','SEA','MarkerIndices', marker_idxS,"Color","#7E2F8E");
semilogy(xaixs,abs(g_vecR-gstar),'^-','DisplayName','R-APM','MarkerIndices', marker_idxR,"Color","#77AC30");
% hold on;

semilogy(xaixs,abs(g_vecPB(1:1000)-gstar),'v-','DisplayName','PB-APG','MarkerIndices', marker_idxPB,"Color","#D95319");
semilogy([0:100:2000],abs(g_vec0(1:21)-gstar),'x-','DisplayName','Bisec-BiO','MarkerIndices', [1:2:21],"Color", "#A2142F");
semilogy(xaixs,abs(g_vecAB(1:1000)-gstar),'*-','DisplayName','AGM-BiO','MarkerIndices', marker_idxAGM,"Color","#4DBEEE");

ylabel('$|g(x_k)-g^*|$')
% xlabel('time (s)')
xlabel('number of gradient evaluations')
set(gca,'FontSize',13);
% set(gca,'YLim',[1e-6,10])
% set(gca,'XLim',[0,80])
legend('Interpreter','latex','Location','northeast')
grid on;
grid minor
pbaspect([1 0.8 1])

% print('-depsc2','-r600','./figs/lower_subopt_time.eps')
%% upper-level gap vs. gradient eval
fstar = 1/2/n;
figure;
set(0,'defaulttextinterpreter','latex')
set(gcf,'DefaultLineLinewidth',5)
set(gcf,'DefaultLineMarkerSize',16);
set(gcf,'Position',[331,167,591,586])

% semilogy(time_vec1,abs(f_vec1-fstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idx1);
% hold on;
% semilogy(time_vec4,abs(f_vec4-fstar),'d-','DisplayName','MNG','MarkerIndices', marker_idx4);
% hold on;
%semilogy(time_vec3,abs(f_vec3-fstar),'^-','DisplayName','BiG-SAM','MarkerIndices', marker_idx3);

semilogy(xaixs,abs(f_vec2-fstar),'s-','DisplayName','a-IRG','MarkerIndices', marker_idx2);
hold on;
% % semilogy(time_vecCB,abs(f_vecCB-fstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idxCB);
semilogy(xaixs,abs(f_vecBSG(1:1000)-fstar),'+-','DisplayName','Bi-SG','MarkerIndices', marker_idxBSG,"Color","#EDB120");
% %semilogy(time_vec5,abs(f_vec5-fstar),'>-','DisplayName','DBGD','MarkerIndices', marker_idx5);
semilogy(xaixs,abs(f_vecS-fstar),'>-','DisplayName','SEA','MarkerIndices', marker_idxS,"Color","#7E2F8E");
semilogy(xaixs,abs(f_vecR-fstar),'^-','DisplayName','R-APM','MarkerIndices', marker_idxR,"Color","#77AC30");
% hold on;

semilogy(xaixs,abs(f_vecPB(1:1000)-fstar),'v-','DisplayName','PB-APG','MarkerIndices', marker_idxPB,"Color","#D95319");
semilogy([0:100:2000],abs(f_vec0(1:21)-fstar),'x-','DisplayName','Bisec-BiO','MarkerIndices', [1:2:21],"Color","#A2142F");
semilogy(xaixs,abs(f_vecAB(1:1000)-fstar),'*-','DisplayName','AGM-BiO','MarkerIndices', marker_idxAGM,"Color","#4DBEEE");

ylabel('$|f(x_k)-f^*|$')
xlabel('time (s)')
xlabel('number of gradient evaluations')
% set(gca,'YLim',[1e-4,1e-2])
set(gca,'FontSize',13);
% set(gca,'YLim',[0,1])
legend('Interpreter','latex','Location','northeast')
grid on;
grid minor
pbaspect([1 0.8 1])


%% lower-level gap
gstar = 0;
figure;
set(0,'defaulttextinterpreter','latex')
set(gcf,'DefaultLineLinewidth',5)
set(gcf,'DefaultLineMarkerSize',16);
set(gcf,'Position',[331,167,591,586])

param.maxtime = maxiter;
xaixs = [1:1:maxiter];
N_marker = 10;
time_idx = linspace(0,param.maxtime,N_marker);
marker_idx1 = zeros(N_marker,1);
marker_idx2 = zeros(N_marker,1);
marker_idx3 = zeros(N_marker,1);
marker_idx4 = zeros(N_marker,1);
marker_idx5 = zeros(N_marker,1);
marker_idxAGM = zeros(N_marker,1);
marker_idxR = zeros(N_marker,1);
marker_idxS = zeros(N_marker,1);
marker_idxBSG = zeros(N_marker,1);
marker_idxCB = zeros(N_marker,1);
marker_idxPB = zeros(N_marker,1);
marker_idxBB = zeros(N_marker,1);
for j=1:N_marker
%     [~,idx] = min(abs(time_vec1-time_idx(j)));
%     marker_idx1(j) = idx;
    [~,idx] = min(abs(xaixs-time_idx(j)));
    marker_idx2(j) = idx;
%     [~,idx] = min(abs(time_vec3-time_idx(j)));
%     marker_idx3(j) = idx;
%     [~,idx] = min(abs(time_vec4-time_idx(j)));
%    marker_idx4(j) = idx;
%    [~,idx] = min(abs(time_vec5-time_idx(j)));
%    marker_idx5(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxR(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxS(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxAGM(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxBSG(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxPB(j) = idx;
   [~,idx] = min(abs(xaixs-time_idx(j)));
   marker_idxBB(j) = idx;
%    [~,idx] = min(abs(time_vecCB-time_idx(j)));
%    marker_idxCB(j) = idx;
end

% semilogy(time_vec1,abs(g_vec1-gstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idx1);
% hold on;
% semilogy(time_vec4,abs(g_vec4-gstar),'d-','DisplayName','MNG','MarkerIndices', marker_idx4);
% hold on;

%semilogy(time_vec3,abs(g_vec3-gstar),'^-','DisplayName','BiG-SAM','MarkerIndices', marker_idx3);


semilogy(time_vec2,abs(g_vec2-gstar),'s-','DisplayName','a-IRG','MarkerIndices', marker_idx2);
hold on;
% % semilogy(time_vecCB,abs(g_vecCB-gstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idxCB);
semilogy(time_vecBSG,abs(g_vecBSG-gstar),'+-','DisplayName','Bi-SG','MarkerIndices', marker_idxBSG,"Color","#EDB120");
% %semilogy(time_vec5,abs(f_vec5-fstar),'>-','DisplayName','DBGD','MarkerIndices', marker_idx5);
semilogy(time_vecS,abs(g_vecS-gstar),'>-','DisplayName','SEA','MarkerIndices', marker_idxS,"Color","#7E2F8E");
semilogy(time_vecR,abs(g_vecR-gstar),'^-','DisplayName','R-APM','MarkerIndices', marker_idxR,"Color","#77AC30");
% hold on;
semilogy(time_vecAB,abs(g_vecAB-gstar),'*-','DisplayName','AGM-BiO','MarkerIndices', marker_idxAGM,"Color","#4DBEEE");
semilogy(time_vecPB,abs(g_vecPB-gstar),'o-','DisplayName','PB-APG','MarkerIndices', marker_idxPB);
semilogy(time_vec0,abs(g_vec0-gstar),'o-','DisplayName','Bisec-BiO','MarkerIndices', marker_idxBB);

ylabel('$|g(x_k)-g^*|$')
% xlabel('time (s)')
xlabel('number of iterations')
set(gca,'FontSize',20);
% set(gca,'YLim',[1e-6,10])
% set(gca,'XLim',[0,80])
legend('Interpreter','latex','Location','northeast')
grid on;
grid minor
pbaspect([1 0.8 1])

% print('-depsc2','-r600','./figs/lower_subopt_time.eps')
%% upper-level gap
fstar = 1/2/n;
figure;
set(0,'defaulttextinterpreter','latex')
set(gcf,'DefaultLineLinewidth',5)
set(gcf,'DefaultLineMarkerSize',16);
set(gcf,'Position',[331,167,591,586])

% semilogy(time_vec1,abs(f_vec1-fstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idx1);
% hold on;
% semilogy(time_vec4,abs(f_vec4-fstar),'d-','DisplayName','MNG','MarkerIndices', marker_idx4);
% hold on;
%semilogy(time_vec3,abs(f_vec3-fstar),'^-','DisplayName','BiG-SAM','MarkerIndices', marker_idx3);

semilogy(time_vec2,abs(f_vec2-fstar),'s-','DisplayName','a-IRG','MarkerIndices', marker_idx2);
hold on;
% % semilogy(time_vecCB,abs(f_vecCB-fstar),'o-','DisplayName','CG-BiO','MarkerIndices', marker_idxCB);
semilogy(time_vecBSG,abs(f_vecBSG-fstar),'+-','DisplayName','Bi-SG','MarkerIndices', marker_idxBSG,"Color","#EDB120");
% %semilogy(time_vec5,abs(f_vec5-fstar),'>-','DisplayName','DBGD','MarkerIndices', marker_idx5);
semilogy(time_vecS,abs(f_vecS-fstar),'>-','DisplayName','SEA','MarkerIndices', marker_idxS,"Color","#7E2F8E");
semilogy(time_vecR,abs(f_vecR-fstar),'^-','DisplayName','R-APM','MarkerIndices', marker_idxR,"Color","#77AC30");
% hold on;
semilogy(time_vecAB,abs(f_vecAB-fstar),'*-','DisplayName','AGM-BiO','MarkerIndices', marker_idxAGM,"Color","#4DBEEE");
semilogy(time_vecPB,abs(f_vecPB-fstar),'o-','DisplayName','PB-APG','MarkerIndices', marker_idxPB);
semilogy(time_vec0,abs(f_vec0-fstar),'o-','DisplayName','Bisec-BiO','MarkerIndices', marker_idxBB);

ylabel('$|f(x_k)-f^*|$')
xlabel('time (s)')
xlabel('number of iterations')
% set(gca,'YLim',[1e-4,1e-2])
set(gca,'FontSize',20);
% set(gca,'YLim',[0,1])
legend('Interpreter','latex','Location','northeast')
grid on;
grid minor
pbaspect([1 0.8 1])
