import os
from pathlib import Path

from probtransformer.utils.configuration import Config


def find_experiments(expt_dir, search_keys):
    expt_dir = Path(expt_dir)
    expt_list = []

    for subdir, dirs, files in os.walk(expt_dir):
        subdir = Path(subdir)

        if os.path.exists(subdir / 'eval_summary.npy') and os.path.exists(subdir / 'config.yml') and all(
                [key in subdir.__str__() for key in search_keys]):
            config = Config(config_file=subdir / 'config.yml')
            # expt_name = config.expt.session_name + "/" + config.expt.experiment_name.split("_seed")[0]
            expt_name = config.expt.session_name + "/" + config.expt.experiment_name
            seed = config.train.seed
            expt_dict = {"dir": subdir, "expt_name": expt_name, "seed": seed,
                         "expt_folder": config.expt.experiment_name, "key": search_keys[0]}

            expt_list.append(expt_dict)
    return expt_list
