
# Source Code for Constrained Parameter Regularization


Please use a system with at least 1 GPU


#### Install env
```bash
bash setup_env.sh
source env/bin/activate
```


## CIFAR-100 Experiment
The CIFAR-100 experiment should run within 20-30 minutes. The results will be saved in the `cifar100` folder.

####  For AdamW:
```bash
python train_cifar100_task.py --optimizer adamw --lr 0.001 --weight_decay 0.001
```

####  For Adam + Rescaling:
```bash
python train_cifar100_task.py --optimizer adamw --lr 0.001 --weight_decay 0 --rescale_alpha 0.8
```

####  For Adam + AWD:
```bash
python train_cifar100_task.py --optimizer adam_awd --lr 0.001 --weight_decay 0.1 
```

####  For Adam + AdaDecay:
```bash
python train_cifar100_task.py --optimizer adam_adadecay --lr 0.001 --weight_decay 0.1 
```

####  For AdamCPR with L2 norm as regularization function and kappa initialization depending on the parameter initialization:
```bash
python train_cifar100_task.py --optimizer adamcpr --lr 0.001 --kappa_init_method dependent --kappa_init_param 1.0
```

####  For AdamCPR with L2 norm as regularization function and kappa initialization with warm start:
```bash
python train_cifar100_task.py --optimizer adamcpr --lr 0.001 --kappa_init_method warm_start --kappa_init_param 1000
```

####  For AdamAdaCPR with L2 norm as regularization function and kappa initialization with inflection point:
```bash
python train_cifar100_task.py --optimizer adamcpr --lr 0.001 --kappa_init_method inflection_point 
```
