#include "timer.hpp"

_timer::_timer() : m_t_start(), m_t_end() {}

_timer::~_timer() {}

void
_timer::start(const std::string & s)
{
   if(m_t_accu.count(s) == 0)
      m_t_accu[s] = 0;

   m_t_start[s] = std::chrono::system_clock::now();
}

void
_timer::stop(const std::string & s)
{
   m_t_end[s]   = std::chrono::system_clock::now();
   auto elapsed = std::chrono::duration_cast<std::chrono::microseconds>(
      m_t_end[s] - m_t_start[s]);
   m_t_accu[s] += (elapsed.count() / 1000.0);
}

void
_timer::clear(const std::string & s)
{
   m_t_accu[s] = 0;
}

double
_timer::get_ms(const std::string & s)
{
   return m_t_accu[s];
}

_timer * __T = new _timer();
