#include <stdint.h>
#include <scip/def.h>
#include "../lc_clock.h"
#include "fwexitcodes.h"

typedef struct
{
   double*    a;                // normal vector of cut
   double     b;                // rhs of cut
   double     frac_viol;        // violation of cut
   int        success;          // whether cut was successfully produced
   exitcode_t exitcode;         // type of termination
   int        noraclecalls;     // number of oracles calls
   int        niters;           // number of FW iterations
} FWTuple;


#ifdef __cplusplus
extern "C" {
#endif
//! run away-step Frank Wolfe algorithm using knapsack oracles
FWTuple* scalar_afw_knap_gen_cut(
   SCIP*                        scip,        // scip instance
   const int                    dim,         // dimension of knapsack
   const SCIP_Longint*          weights,     // integer weights of knapsack
   const SCIP_Longint           capacity,    // capacity of knapsack
   const double*                xsep,        //! point to be separated -> size dim
   const double*                xint,        //! relative interior point (size dim)
   LC_CLOCK*                    fwclock,     //!< clock for measuring FW time */
   LC_CLOCK*                    oracleclock, //!< clock for measuring oracle time */
   double                       primallimit, //! stop FW if primal value falls below this limit
   uint64_t                     max_iters    //! maximal number of iterations
   );
#ifdef __cplusplus
}
#endif
