#import os
#os.environ['R_HOME'] = '/Library/Frameworks/R.framework/Resources'

from pylab import *
import numpy as np
import pandas as pd
import time, sys, dill
from statsmodels.stats.multicomp import pairwise_tukeyhsd

models = ['cox', 'gbm', 'sf', 'spp']
nsub = [736, 7273, 36594, 72959]
score_t = [0.3,0.5,0.7,0.9]
cpu_nint = [1,5,10,20,50]
colors = {'spp':'red', 'cox':'cyan', 'gbm':'lime', 'sf':'gold'}

linewidth = 1.0
boxwidth = 0.2
ylimm = {'tll': [-0.6,0.5], 'auc':[0.55,0.85]} # linear
#ylimm = {'tll': [-0.6,0.2], 'auc':[0.1,1.0]}

cpu = {m:[] for m in models}
cpu['cox'].append(dill.load(open('result/nonlinear/cox_data_nsub1000nint10.dill','rb'))['cpu'])
cpu['cox'].append(dill.load(open('result/nonlinear/cox_data_nsub10000nint10.dill','rb'))['cpu'])
cpu['cox'].append(dill.load(open('result/nonlinear/cox_data_nsub50000nint10.dill','rb'))['cpu'])
cpu['cox'].append(dill.load(open('result/nonlinear/cox_data_nsub100000nint10.dill','rb'))['cpu'])
cpu['spp'].append(dill.load(open('result/nonlinear/spp_data_nsub1000nint10.dill','rb'))['cpu'])
cpu['spp'].append(dill.load(open('result/nonlinear/spp_data_nsub10000nint10.dill','rb'))['cpu'])
cpu['spp'].append(dill.load(open('result/nonlinear/spp_data_nsub50000nint10.dill','rb'))['cpu'])
cpu['spp'].append(dill.load(open('result/nonlinear/spp_data_nsub100000nint10.dill','rb'))['cpu'])
cpu['gbm'].append(dill.load(open('result/nonlinear/gbm_data_nsub1000nint10.dill','rb'))['cpu'])
cpu['gbm'].append(dill.load(open('result/nonlinear/gbm_data_nsub10000nint10.dill','rb'))['cpu'])
cpu['sf'].append(dill.load(open('result/nonlinear/sf_data_nsub1000nint10.dill','rb'))['cpu'])
cpu['sf'].append(dill.load(open('result/nonlinear/sf_data_nsub10000nint10.dill','rb'))['cpu'])


figure(figsize=(15,6))

title('cpu')
yscale('log')
xscale('log')
xlim(500,100000)
ylim(0.01,1000)

m = 'spp'
errorbar(nsub, array(mean(cpu[m],1))/9., yerr=std(cpu[m],1)/9., capsize=5,
         fmt='o', markersize=5, ecolor=colors[m], markerfacecolor=colors[m],
         markeredgecolor=colors[m])
plot(nsub, mean(cpu[m],1)/9.,colors[m])
m = 'cox'
errorbar(nsub, array(mean(cpu[m],1)), yerr=std(cpu[m],1), capsize=5,
         fmt='o', markersize=5, ecolor=colors[m], markerfacecolor=colors[m],
         markeredgecolor=colors[m])
plot(nsub, mean(cpu[m],1),colors[m])
m = 'gbm'
errorbar(nsub[:2], array(mean(cpu[m],1))/9., yerr=std(cpu[m],1)/9., capsize=5,
         fmt='o', markersize=5, ecolor=colors[m], markerfacecolor=colors[m],
         markeredgecolor=colors[m])
plot(nsub[:2], mean(cpu[m],1)/9.,colors[m])
m = 'sf'
mean_sf = [mean(x) for x in cpu[m]]
std_sf = [std(x) for x in cpu[m]]
errorbar(nsub[:2], mean_sf, yerr=std_sf, capsize=5,
         fmt='o', markersize=5, ecolor=colors[m], markerfacecolor=colors[m],
         markeredgecolor=colors[m])
plot(nsub[:2], mean_sf,colors[m])

x = array([500,100000])
plot(x,0.004*x,'k--',linewidth=0.5)

tight_layout()
savefig('result/nonlinear/figure_nonlinear_cpu.eps')

print(cpu)
sys.exit()

