import hashlib

def salted_sha256(salt):
    """
    Returns a function from strings to integers based on sha256 with salt
    appended.

    >>> my_hash = salted_sha256("sea salt")
    >>> my_hash("potatoes") % 256
    132
    """
    def hasher(s):
        return int(hashlib.sha256((s + salt).encode("utf-8")).hexdigest(), 16)
    return hasher
