import argparse
import os
import shutil
from adversarialML.biologically_inspired_models.src.utils import load_json, write_pickle

parser = argparse.ArgumentParser()
parser.add_argument('--dir')
args = parser.parse_args()

outfile = f'{args.dir}/randomized_smoothing_preds_and_radii.pkl'

result_files = [f'{args.dir}/{f}' for f in os.listdir(args.dir)]
pnr = {}
for fp in result_files:
    r = load_json(fp)
    name, _ = fp.replace('rs_result_', '').split('_')
    for k,v in r:
        pnr.setdefault(name, {}).setdefault(k, []).append(v)
outdict = {'preds_and_radii': pnr}

if os.path.exists(outfile):
    os.rename(outfile, f'{os.path.dirname(outfile)}/.{os.path.basename(outfile)}')

write_pickle(outdict, outfile)